<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customerget ServiceType
 * @subpackage Services
 */
class Customerget extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named customer_getById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_getById $parameters
     * @return \StructType\Customer_getByIdResponse|bool
     */
    public function customer_getById(\StructType\Customer_getById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_getById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customer_getByAccountId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_getByAccountId $parameters
     * @return \StructType\Customer_getByAccountIdResponse|bool
     */
    public function customer_getByAccountId(\StructType\Customer_getByAccountId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_getByAccountId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customer_getGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_getGroups $parameters
     * @return \StructType\Customer_getGroupsResponse|bool
     */
    public function customer_getGroups(\StructType\Customer_getGroups $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_getGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customer_getAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_getAll $parameters
     * @return \StructType\Customer_getAllResponse|bool
     */
    public function customer_getAll(\StructType\Customer_getAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_getAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customer_getByObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_getByObject $parameters
     * @return \StructType\Customer_getByObjectResponse|bool
     */
    public function customer_getByObject(\StructType\Customer_getByObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_getByObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customer_getByEmailAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_getByEmailAddress $parameters
     * @return \StructType\Customer_getByEmailAddressResponse|bool
     */
    public function customer_getByEmailAddress(\StructType\Customer_getByEmailAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_getByEmailAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customer_getByMobilePhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_getByMobilePhone $parameters
     * @return \StructType\Customer_getByMobilePhoneResponse|bool
     */
    public function customer_getByMobilePhone(\StructType\Customer_getByMobilePhone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_getByMobilePhone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customer_getByExternalId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_getByExternalId $parameters
     * @return \StructType\Customer_getByExternalIdResponse|bool
     */
    public function customer_getByExternalId(\StructType\Customer_getByExternalId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_getByExternalId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customer_getByUserNameAndPassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_getByUserNameAndPassword $parameters
     * @return \StructType\Customer_getByUserNameAndPasswordResponse|bool
     */
    public function customer_getByUserNameAndPassword(\StructType\Customer_getByUserNameAndPassword $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_getByUserNameAndPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customer_getTotalNumberOfCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_getTotalNumberOfCustomers $parameters
     * @return \StructType\Customer_getTotalNumberOfCustomersResponse|bool
     */
    public function customer_getTotalNumberOfCustomers(\StructType\Customer_getTotalNumberOfCustomers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_getTotalNumberOfCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Customer_getAllResponse|\StructType\Customer_getByAccountIdResponse|\StructType\Customer_getByEmailAddressResponse|\StructType\Customer_getByExternalIdResponse|\StructType\Customer_getByIdResponse|\StructType\Customer_getByMobilePhoneResponse|\StructType\Customer_getByObjectResponse|\StructType\Customer_getByUserNameAndPasswordResponse|\StructType\Customer_getGroupsResponse|\StructType\Customer_getTotalNumberOfCustomersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
