<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Complaint ServiceType
 * @subpackage Services
 */
class Complaint extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named complaintSet_getComplaint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ComplaintSet_getComplaint $parameters
     * @return \StructType\ComplaintSet_getComplaintResponse|bool
     */
    public function complaintSet_getComplaint(\StructType\ComplaintSet_getComplaint $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->complaintSet_getComplaint($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named complaintSet_getComplaints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ComplaintSet_getComplaints $parameters
     * @return \StructType\ComplaintSet_getComplaintsResponse|bool
     */
    public function complaintSet_getComplaints(\StructType\ComplaintSet_getComplaints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->complaintSet_getComplaints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named complaintSet_getComplaintIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ComplaintSet_getComplaintIds $parameters
     * @return \StructType\ComplaintSet_getComplaintIdsResponse|bool
     */
    public function complaintSet_getComplaintIds(\StructType\ComplaintSet_getComplaintIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->complaintSet_getComplaintIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ComplaintSet_getComplaintIdsResponse|\StructType\ComplaintSet_getComplaintResponse|\StructType\ComplaintSet_getComplaintsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
