<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Campaignget ServiceType
 * @subpackage Services
 */
class Campaignget extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named campaign_getAllExecutable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Campaign_getAllExecutable $parameters
     * @return \StructType\Campaign_getAllExecutableResponse|bool
     */
    public function campaign_getAllExecutable(\StructType\Campaign_getAllExecutable $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->campaign_getAllExecutable($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named campaign_getMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Campaign_getMembers $parameters
     * @return \StructType\Campaign_getMembersResponse|bool
     */
    public function campaign_getMembers(\StructType\Campaign_getMembers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->campaign_getMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Campaign_getAllExecutableResponse|\StructType\Campaign_getMembersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
