<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Campaignexecute ServiceType
 * @subpackage Services
 */
class Campaignexecute extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named campaign_execute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Campaign_execute $parameters
     * @return \StructType\Campaign_executeResponse|bool
     */
    public function campaign_execute(\StructType\Campaign_execute $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->campaign_execute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named campaign_executeAsync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Campaign_executeAsync $parameters
     * @return \StructType\Campaign_executeAsyncResponse|bool
     */
    public function campaign_executeAsync(\StructType\Campaign_executeAsync $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->campaign_executeAsync($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Campaign_executeAsyncResponse|\StructType\Campaign_executeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
