<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Campaign ServiceType
 * @subpackage Services
 */
class Campaign extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named campaignStatistics_getByCampaignId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CampaignStatistics_getByCampaignId $parameters
     * @return \StructType\CampaignStatistics_getByCampaignIdResponse|bool
     */
    public function campaignStatistics_getByCampaignId(\StructType\CampaignStatistics_getByCampaignId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->campaignStatistics_getByCampaignId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named campaignStatistics_getCustomerSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CampaignStatistics_getCustomerSet $parameters
     * @return \StructType\CampaignStatistics_getCustomerSetResponse|bool
     */
    public function campaignStatistics_getCustomerSet(\StructType\CampaignStatistics_getCustomerSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->campaignStatistics_getCustomerSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * campaignObjectStatistics_getByCampaignObjectId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CampaignObjectStatistics_getByCampaignObjectId $parameters
     * @return \StructType\CampaignObjectStatistics_getByCampaignObjectIdResponse|bool
     */
    public function campaignObjectStatistics_getByCampaignObjectId(\StructType\CampaignObjectStatistics_getByCampaignObjectId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->campaignObjectStatistics_getByCampaignObjectId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * campaignObjectStatisticsOption_getCustomerSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CampaignObjectStatisticsOption_getCustomerSet $parameters
     * @return \StructType\CampaignObjectStatisticsOption_getCustomerSetResponse|bool
     */
    public function campaignObjectStatisticsOption_getCustomerSet(\StructType\CampaignObjectStatisticsOption_getCustomerSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->campaignObjectStatisticsOption_getCustomerSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CampaignObjectStatisticsOption_getCustomerSetResponse|\StructType\CampaignObjectStatistics_getByCampaignObjectIdResponse|\StructType\CampaignStatistics_getByCampaignIdResponse|\StructType\CampaignStatistics_getCustomerSetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
