<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bounceget ServiceType
 * @subpackage Services
 */
class Bounceget extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named bounce_getById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Bounce_getById $parameters
     * @return \StructType\Bounce_getByIdResponse|bool
     */
    public function bounce_getById(\StructType\Bounce_getById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->bounce_getById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Bounce_getByIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
