<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOption ArrayType
 * @subpackage Arrays
 */
class ArrayOfOption extends AbstractStructArrayBase
{
    /**
     * The Option
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Option[]
     */
    public $Option;
    /**
     * Constructor method for ArrayOfOption
     * @uses ArrayOfOption::setOption()
     * @param \StructType\Option[] $option
     */
    public function __construct(array $option = array())
    {
        $this
            ->setOption($option);
    }
    /**
     * Get Option value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Option[]|null
     */
    public function getOption()
    {
        return isset($this->Option) ? $this->Option : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptionForArrayConstraintsFromSetOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOptionOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfOptionOptionItem instanceof \StructType\Option) {
                $invalidValues[] = is_object($arrayOfOptionOptionItem) ? get_class($arrayOfOptionOptionItem) : sprintf('%s(%s)', gettype($arrayOfOptionOptionItem), var_export($arrayOfOptionOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Option property can only contain items of type \StructType\Option, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Option value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Option[] $option
     * @return \ArrayType\ArrayOfOption
     */
    public function setOption(array $option = array())
    {
        // validation for constraint: array
        if ('' !== ($optionArrayErrorMessage = self::validateOptionForArrayConstraintsFromSetOption($option))) {
            throw new \InvalidArgumentException($optionArrayErrorMessage, __LINE__);
        }
        if (is_null($option) || (is_array($option) && empty($option))) {
            unset($this->Option);
        } else {
            $this->Option = $option;
        }
        return $this;
    }
    /**
     * Add item to Option value
     * @throws \InvalidArgumentException
     * @param \StructType\Option $item
     * @return \ArrayType\ArrayOfOption
     */
    public function addToOption(\StructType\Option $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Option) {
            throw new \InvalidArgumentException(sprintf('The Option property can only contain items of type \StructType\Option, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Option[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Option|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Option|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Option|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Option|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Option|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Option
     */
    public function getAttributeName()
    {
        return 'Option';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
