<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMethodOptions ArrayType
 * @subpackage Arrays
 */
class ArrayOfMethodOptions extends AbstractStructArrayBase
{
    /**
     * The MethodOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MethodOptions[]
     */
    public $MethodOptions;
    /**
     * Constructor method for ArrayOfMethodOptions
     * @uses ArrayOfMethodOptions::setMethodOptions()
     * @param \StructType\MethodOptions[] $methodOptions
     */
    public function __construct(array $methodOptions = array())
    {
        $this
            ->setMethodOptions($methodOptions);
    }
    /**
     * Get MethodOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MethodOptions[]|null
     */
    public function getMethodOptions()
    {
        return isset($this->MethodOptions) ? $this->MethodOptions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMethodOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMethodOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMethodOptionsForArrayConstraintsFromSetMethodOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMethodOptionsMethodOptionsItem) {
            // validation for constraint: itemType
            if (!$arrayOfMethodOptionsMethodOptionsItem instanceof \StructType\MethodOptions) {
                $invalidValues[] = is_object($arrayOfMethodOptionsMethodOptionsItem) ? get_class($arrayOfMethodOptionsMethodOptionsItem) : sprintf('%s(%s)', gettype($arrayOfMethodOptionsMethodOptionsItem), var_export($arrayOfMethodOptionsMethodOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MethodOptions property can only contain items of type \StructType\MethodOptions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MethodOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MethodOptions[] $methodOptions
     * @return \ArrayType\ArrayOfMethodOptions
     */
    public function setMethodOptions(array $methodOptions = array())
    {
        // validation for constraint: array
        if ('' !== ($methodOptionsArrayErrorMessage = self::validateMethodOptionsForArrayConstraintsFromSetMethodOptions($methodOptions))) {
            throw new \InvalidArgumentException($methodOptionsArrayErrorMessage, __LINE__);
        }
        if (is_null($methodOptions) || (is_array($methodOptions) && empty($methodOptions))) {
            unset($this->MethodOptions);
        } else {
            $this->MethodOptions = $methodOptions;
        }
        return $this;
    }
    /**
     * Add item to MethodOptions value
     * @throws \InvalidArgumentException
     * @param \StructType\MethodOptions $item
     * @return \ArrayType\ArrayOfMethodOptions
     */
    public function addToMethodOptions(\StructType\MethodOptions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MethodOptions) {
            throw new \InvalidArgumentException(sprintf('The MethodOptions property can only contain items of type \StructType\MethodOptions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MethodOptions[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MethodOptions|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MethodOptions|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MethodOptions|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MethodOptions|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MethodOptions|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MethodOptions
     */
    public function getAttributeName()
    {
        return 'MethodOptions';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMethodOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
