<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerOption ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerOption extends AbstractStructArrayBase
{
    /**
     * The CustomerOption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerOption[]
     */
    public $CustomerOption;
    /**
     * Constructor method for ArrayOfCustomerOption
     * @uses ArrayOfCustomerOption::setCustomerOption()
     * @param \StructType\CustomerOption[] $customerOption
     */
    public function __construct(array $customerOption = array())
    {
        $this
            ->setCustomerOption($customerOption);
    }
    /**
     * Get CustomerOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerOption[]|null
     */
    public function getCustomerOption()
    {
        return isset($this->CustomerOption) ? $this->CustomerOption : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerOptionForArrayConstraintsFromSetCustomerOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerOptionCustomerOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerOptionCustomerOptionItem instanceof \StructType\CustomerOption) {
                $invalidValues[] = is_object($arrayOfCustomerOptionCustomerOptionItem) ? get_class($arrayOfCustomerOptionCustomerOptionItem) : sprintf('%s(%s)', gettype($arrayOfCustomerOptionCustomerOptionItem), var_export($arrayOfCustomerOptionCustomerOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerOption property can only contain items of type \StructType\CustomerOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerOption[] $customerOption
     * @return \ArrayType\ArrayOfCustomerOption
     */
    public function setCustomerOption(array $customerOption = array())
    {
        // validation for constraint: array
        if ('' !== ($customerOptionArrayErrorMessage = self::validateCustomerOptionForArrayConstraintsFromSetCustomerOption($customerOption))) {
            throw new \InvalidArgumentException($customerOptionArrayErrorMessage, __LINE__);
        }
        if (is_null($customerOption) || (is_array($customerOption) && empty($customerOption))) {
            unset($this->CustomerOption);
        } else {
            $this->CustomerOption = $customerOption;
        }
        return $this;
    }
    /**
     * Add item to CustomerOption value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerOption $item
     * @return \ArrayType\ArrayOfCustomerOption
     */
    public function addToCustomerOption(\StructType\CustomerOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerOption) {
            throw new \InvalidArgumentException(sprintf('The CustomerOption property can only contain items of type \StructType\CustomerOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerOption[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerOption|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerOption|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerOption|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerOption|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerOption|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerOption
     */
    public function getAttributeName()
    {
        return 'CustomerOption';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomerOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
