<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClick ArrayType
 * @subpackage Arrays
 */
class ArrayOfClick extends AbstractStructArrayBase
{
    /**
     * The Click
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Click[]
     */
    public $Click;
    /**
     * Constructor method for ArrayOfClick
     * @uses ArrayOfClick::setClick()
     * @param \StructType\Click[] $click
     */
    public function __construct(array $click = array())
    {
        $this
            ->setClick($click);
    }
    /**
     * Get Click value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Click[]|null
     */
    public function getClick()
    {
        return isset($this->Click) ? $this->Click : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClick method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClick method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClickForArrayConstraintsFromSetClick(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfClickClickItem) {
            // validation for constraint: itemType
            if (!$arrayOfClickClickItem instanceof \StructType\Click) {
                $invalidValues[] = is_object($arrayOfClickClickItem) ? get_class($arrayOfClickClickItem) : sprintf('%s(%s)', gettype($arrayOfClickClickItem), var_export($arrayOfClickClickItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Click property can only contain items of type \StructType\Click, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Click value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Click[] $click
     * @return \ArrayType\ArrayOfClick
     */
    public function setClick(array $click = array())
    {
        // validation for constraint: array
        if ('' !== ($clickArrayErrorMessage = self::validateClickForArrayConstraintsFromSetClick($click))) {
            throw new \InvalidArgumentException($clickArrayErrorMessage, __LINE__);
        }
        if (is_null($click) || (is_array($click) && empty($click))) {
            unset($this->Click);
        } else {
            $this->Click = $click;
        }
        return $this;
    }
    /**
     * Add item to Click value
     * @throws \InvalidArgumentException
     * @param \StructType\Click $item
     * @return \ArrayType\ArrayOfClick
     */
    public function addToClick(\StructType\Click $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Click) {
            throw new \InvalidArgumentException(sprintf('The Click property can only contain items of type \StructType\Click, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Click[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Click|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Click|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Click|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Click|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Click|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Click
     */
    public function getAttributeName()
    {
        return 'Click';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfClick
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
