<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBounce ArrayType
 * @subpackage Arrays
 */
class ArrayOfBounce extends AbstractStructArrayBase
{
    /**
     * The Bounce
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bounce[]
     */
    public $Bounce;
    /**
     * Constructor method for ArrayOfBounce
     * @uses ArrayOfBounce::setBounce()
     * @param \StructType\Bounce[] $bounce
     */
    public function __construct(array $bounce = array())
    {
        $this
            ->setBounce($bounce);
    }
    /**
     * Get Bounce value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bounce[]|null
     */
    public function getBounce()
    {
        return isset($this->Bounce) ? $this->Bounce : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBounce method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBounce method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBounceForArrayConstraintsFromSetBounce(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBounceBounceItem) {
            // validation for constraint: itemType
            if (!$arrayOfBounceBounceItem instanceof \StructType\Bounce) {
                $invalidValues[] = is_object($arrayOfBounceBounceItem) ? get_class($arrayOfBounceBounceItem) : sprintf('%s(%s)', gettype($arrayOfBounceBounceItem), var_export($arrayOfBounceBounceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Bounce property can only contain items of type \StructType\Bounce, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Bounce value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Bounce[] $bounce
     * @return \ArrayType\ArrayOfBounce
     */
    public function setBounce(array $bounce = array())
    {
        // validation for constraint: array
        if ('' !== ($bounceArrayErrorMessage = self::validateBounceForArrayConstraintsFromSetBounce($bounce))) {
            throw new \InvalidArgumentException($bounceArrayErrorMessage, __LINE__);
        }
        if (is_null($bounce) || (is_array($bounce) && empty($bounce))) {
            unset($this->Bounce);
        } else {
            $this->Bounce = $bounce;
        }
        return $this;
    }
    /**
     * Add item to Bounce value
     * @throws \InvalidArgumentException
     * @param \StructType\Bounce $item
     * @return \ArrayType\ArrayOfBounce
     */
    public function addToBounce(\StructType\Bounce $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bounce) {
            throw new \InvalidArgumentException(sprintf('The Bounce property can only contain items of type \StructType\Bounce, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Bounce[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Bounce|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Bounce|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Bounce|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Bounce|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Bounce|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Bounce
     */
    public function getAttributeName()
    {
        return 'Bounce';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBounce
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
