<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Array StructType
 * Meta information extracted from the WSDL
 * - documentation: 'Array' is a complex type for accessors identified by position
 * - type: tns:Array
 * @subpackage Structs
 */
class _Array extends AbstractStructBase
{
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The arrayType
     * @var \StructType\_string
     */
    public $arrayType;
    /**
     * The offset
     * Meta information extracted from the WSDL
     * - base: xs:string
     * @var \StructType\_string[]
     */
    public $offset;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - type: xs:ID
     * @var \StructType\ID
     */
    public $id;
    /**
     * The href
     * Meta information extracted from the WSDL
     * - type: xs:anyURI
     * @var \StructType\AnyURI
     */
    public $href;
    /**
     * Constructor method for Array
     * @uses _Array::setAny()
     * @uses _Array::setArrayType()
     * @uses _Array::setOffset()
     * @uses _Array::setId()
     * @uses _Array::setHref()
     * @param \DOMDocument $any
     * @param \StructType\_string $arrayType
     * @param \StructType\_string[] $offset
     * @param \StructType\ID $id
     * @param \StructType\AnyURI $href
     */
    public function __construct(\DOMDocument $any = null, \StructType\_string $arrayType = null, array $offset = array(), \StructType\ID $id = null, \StructType\AnyURI $href = null)
    {
        $this
            ->setAny($any)
            ->setArrayType($arrayType)
            ->setOffset($offset)
            ->setId($id)
            ->setHref($href);
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\_Array
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get arrayType value
     * @return \StructType\_string|null
     */
    public function getArrayType()
    {
        return $this->arrayType;
    }
    /**
     * Set arrayType value
     * @param \StructType\_string $arrayType
     * @return \StructType\_Array
     */
    public function setArrayType(\StructType\_string $arrayType = null)
    {
        $this->arrayType = $arrayType;
        return $this;
    }
    /**
     * Get offset value
     * @return \StructType\_string[]|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * This method is responsible for validating the values passed to the setOffset method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffset method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOffsetForArrayConstraintsFromSetOffset(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOffsetItem) {
            // validation for constraint: itemType
            if (!$arrayOffsetItem instanceof \StructType\_string) {
                $invalidValues[] = is_object($arrayOffsetItem) ? get_class($arrayOffsetItem) : sprintf('%s(%s)', gettype($arrayOffsetItem), var_export($arrayOffsetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The offset property can only contain items of type \StructType\_string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set offset value
     * @throws \InvalidArgumentException
     * @param \StructType\_string[] $offset
     * @return \StructType\_Array
     */
    public function setOffset(array $offset = array())
    {
        // validation for constraint: array
        if ('' !== ($offsetArrayErrorMessage = self::validateOffsetForArrayConstraintsFromSetOffset($offset))) {
            throw new \InvalidArgumentException($offsetArrayErrorMessage, __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Add item to offset value
     * @throws \InvalidArgumentException
     * @param \StructType\_string $item
     * @return \StructType\_Array
     */
    public function addToOffset(\StructType\_string $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\_string) {
            throw new \InvalidArgumentException(sprintf('The offset property can only contain items of type \StructType\_string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->offset[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return \StructType\ID|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\ID $id
     * @return \StructType\_Array
     */
    public function setId(\StructType\ID $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get href value
     * @return \StructType\AnyURI|null
     */
    public function getHref()
    {
        return $this->href;
    }
    /**
     * Set href value
     * @param \StructType\AnyURI $href
     * @return \StructType\_Array
     */
    public function setHref(\StructType\AnyURI $href = null)
    {
        $this->href = $href;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\_Array
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
