<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Struct StructType
 * Meta information extracted from the WSDL
 * - type: tns:Struct
 * @subpackage Structs
 */
class Struct extends AbstractStructBase
{
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - type: xs:ID
     * @var \StructType\ID
     */
    public $id;
    /**
     * The href
     * Meta information extracted from the WSDL
     * - type: xs:anyURI
     * @var \StructType\AnyURI
     */
    public $href;
    /**
     * Constructor method for Struct
     * @uses Struct::setAny()
     * @uses Struct::setId()
     * @uses Struct::setHref()
     * @param \DOMDocument $any
     * @param \StructType\ID $id
     * @param \StructType\AnyURI $href
     */
    public function __construct(\DOMDocument $any = null, \StructType\ID $id = null, \StructType\AnyURI $href = null)
    {
        $this
            ->setAny($any)
            ->setId($id)
            ->setHref($href);
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\Struct
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return \StructType\ID|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\ID $id
     * @return \StructType\Struct
     */
    public function setId(\StructType\ID $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get href value
     * @return \StructType\AnyURI|null
     */
    public function getHref()
    {
        return $this->href;
    }
    /**
     * Set href value
     * @param \StructType\AnyURI $href
     * @return \StructType\Struct
     */
    public function setHref(\StructType\AnyURI $href = null)
    {
        $this->href = $href;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Struct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
