<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MethodOptions StructType
 * @subpackage Structs
 */
class MethodOptions extends AbstractStructBase
{
    /**
     * The method
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $method;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOption
     */
    public $options;
    /**
     * Constructor method for MethodOptions
     * @uses MethodOptions::setMethod()
     * @uses MethodOptions::setOptions()
     * @param \StructType\_string $method
     * @param \ArrayType\ArrayOfOption $options
     */
    public function __construct(\StructType\_string $method = null, \ArrayType\ArrayOfOption $options = null)
    {
        $this
            ->setMethod($method)
            ->setOptions($options);
    }
    /**
     * Get method value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getMethod()
    {
        return isset($this->method) ? $this->method : null;
    }
    /**
     * Set method value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $method
     * @return \StructType\MethodOptions
     */
    public function setMethod(\StructType\_string $method = null)
    {
        if (is_null($method) || (is_array($method) && empty($method))) {
            unset($this->method);
        } else {
            $this->method = $method;
        }
        return $this;
    }
    /**
     * Get options value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOption|null
     */
    public function getOptions()
    {
        return isset($this->options) ? $this->options : null;
    }
    /**
     * Set options value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOption $options
     * @return \StructType\MethodOptions
     */
    public function setOptions(\ArrayType\ArrayOfOption $options = null)
    {
        if (is_null($options) || (is_array($options) && empty($options))) {
            unset($this->options);
        } else {
            $this->options = $options;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MethodOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
