<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Mailing StructType
 * @subpackage Structs
 */
class Mailing extends AbstractStructBase
{
    /**
     * The plannedFor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $plannedFor;
    /**
     * The uniqueClicks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $uniqueClicks;
    /**
     * The uniqueOpens
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $uniqueOpens;
    /**
     * The received
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $received;
    /**
     * The campaignId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $campaignId;
    /**
     * The campaignName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $campaignName;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $id;
    /**
     * The contentName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $contentName;
    /**
     * The sourceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $sourceType;
    /**
     * The sourceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $sourceName;
    /**
     * The customers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $customers;
    /**
     * The throttle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $throttle;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $status;
    /**
     * The links
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMailingLink
     */
    public $links;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $type;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $description;
    /**
     * The startedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $startedAt;
    /**
     * The endedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $endedAt;
    /**
     * The bounces
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $bounces;
    /**
     * The opens
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $opens;
    /**
     * The clicks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $clicks;
    /**
     * The complaints
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $complaints;
    /**
     * Constructor method for Mailing
     * @uses Mailing::setPlannedFor()
     * @uses Mailing::setUniqueClicks()
     * @uses Mailing::setUniqueOpens()
     * @uses Mailing::setReceived()
     * @uses Mailing::setCampaignId()
     * @uses Mailing::setCampaignName()
     * @uses Mailing::setId()
     * @uses Mailing::setContentName()
     * @uses Mailing::setSourceType()
     * @uses Mailing::setSourceName()
     * @uses Mailing::setCustomers()
     * @uses Mailing::setThrottle()
     * @uses Mailing::setStatus()
     * @uses Mailing::setLinks()
     * @uses Mailing::setType()
     * @uses Mailing::setDescription()
     * @uses Mailing::setStartedAt()
     * @uses Mailing::setEndedAt()
     * @uses Mailing::setBounces()
     * @uses Mailing::setOpens()
     * @uses Mailing::setClicks()
     * @uses Mailing::setComplaints()
     * @param \StructType\_string $plannedFor
     * @param \StructType\Long $uniqueClicks
     * @param \StructType\Long $uniqueOpens
     * @param \StructType\Long $received
     * @param \StructType\Long $campaignId
     * @param \StructType\_string $campaignName
     * @param \StructType\Long $id
     * @param \StructType\_string $contentName
     * @param \StructType\_string $sourceType
     * @param \StructType\_string $sourceName
     * @param \StructType\Long $customers
     * @param \StructType\Long $throttle
     * @param \StructType\_string $status
     * @param \ArrayType\ArrayOfMailingLink $links
     * @param \StructType\_string $type
     * @param \StructType\_string $description
     * @param \StructType\_string $startedAt
     * @param \StructType\_string $endedAt
     * @param \StructType\Long $bounces
     * @param \StructType\Long $opens
     * @param \StructType\Long $clicks
     * @param \StructType\Long $complaints
     */
    public function __construct(\StructType\_string $plannedFor = null, \StructType\Long $uniqueClicks = null, \StructType\Long $uniqueOpens = null, \StructType\Long $received = null, \StructType\Long $campaignId = null, \StructType\_string $campaignName = null, \StructType\Long $id = null, \StructType\_string $contentName = null, \StructType\_string $sourceType = null, \StructType\_string $sourceName = null, \StructType\Long $customers = null, \StructType\Long $throttle = null, \StructType\_string $status = null, \ArrayType\ArrayOfMailingLink $links = null, \StructType\_string $type = null, \StructType\_string $description = null, \StructType\_string $startedAt = null, \StructType\_string $endedAt = null, \StructType\Long $bounces = null, \StructType\Long $opens = null, \StructType\Long $clicks = null, \StructType\Long $complaints = null)
    {
        $this
            ->setPlannedFor($plannedFor)
            ->setUniqueClicks($uniqueClicks)
            ->setUniqueOpens($uniqueOpens)
            ->setReceived($received)
            ->setCampaignId($campaignId)
            ->setCampaignName($campaignName)
            ->setId($id)
            ->setContentName($contentName)
            ->setSourceType($sourceType)
            ->setSourceName($sourceName)
            ->setCustomers($customers)
            ->setThrottle($throttle)
            ->setStatus($status)
            ->setLinks($links)
            ->setType($type)
            ->setDescription($description)
            ->setStartedAt($startedAt)
            ->setEndedAt($endedAt)
            ->setBounces($bounces)
            ->setOpens($opens)
            ->setClicks($clicks)
            ->setComplaints($complaints);
    }
    /**
     * Get plannedFor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getPlannedFor()
    {
        return isset($this->plannedFor) ? $this->plannedFor : null;
    }
    /**
     * Set plannedFor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $plannedFor
     * @return \StructType\Mailing
     */
    public function setPlannedFor(\StructType\_string $plannedFor = null)
    {
        if (is_null($plannedFor) || (is_array($plannedFor) && empty($plannedFor))) {
            unset($this->plannedFor);
        } else {
            $this->plannedFor = $plannedFor;
        }
        return $this;
    }
    /**
     * Get uniqueClicks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getUniqueClicks()
    {
        return isset($this->uniqueClicks) ? $this->uniqueClicks : null;
    }
    /**
     * Set uniqueClicks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $uniqueClicks
     * @return \StructType\Mailing
     */
    public function setUniqueClicks(\StructType\Long $uniqueClicks = null)
    {
        if (is_null($uniqueClicks) || (is_array($uniqueClicks) && empty($uniqueClicks))) {
            unset($this->uniqueClicks);
        } else {
            $this->uniqueClicks = $uniqueClicks;
        }
        return $this;
    }
    /**
     * Get uniqueOpens value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getUniqueOpens()
    {
        return isset($this->uniqueOpens) ? $this->uniqueOpens : null;
    }
    /**
     * Set uniqueOpens value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $uniqueOpens
     * @return \StructType\Mailing
     */
    public function setUniqueOpens(\StructType\Long $uniqueOpens = null)
    {
        if (is_null($uniqueOpens) || (is_array($uniqueOpens) && empty($uniqueOpens))) {
            unset($this->uniqueOpens);
        } else {
            $this->uniqueOpens = $uniqueOpens;
        }
        return $this;
    }
    /**
     * Get received value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getReceived()
    {
        return isset($this->received) ? $this->received : null;
    }
    /**
     * Set received value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $received
     * @return \StructType\Mailing
     */
    public function setReceived(\StructType\Long $received = null)
    {
        if (is_null($received) || (is_array($received) && empty($received))) {
            unset($this->received);
        } else {
            $this->received = $received;
        }
        return $this;
    }
    /**
     * Get campaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getCampaignId()
    {
        return isset($this->campaignId) ? $this->campaignId : null;
    }
    /**
     * Set campaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $campaignId
     * @return \StructType\Mailing
     */
    public function setCampaignId(\StructType\Long $campaignId = null)
    {
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->campaignId);
        } else {
            $this->campaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get campaignName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getCampaignName()
    {
        return isset($this->campaignName) ? $this->campaignName : null;
    }
    /**
     * Set campaignName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $campaignName
     * @return \StructType\Mailing
     */
    public function setCampaignName(\StructType\_string $campaignName = null)
    {
        if (is_null($campaignName) || (is_array($campaignName) && empty($campaignName))) {
            unset($this->campaignName);
        } else {
            $this->campaignName = $campaignName;
        }
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $id
     * @return \StructType\Mailing
     */
    public function setId(\StructType\Long $id = null)
    {
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get contentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getContentName()
    {
        return isset($this->contentName) ? $this->contentName : null;
    }
    /**
     * Set contentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $contentName
     * @return \StructType\Mailing
     */
    public function setContentName(\StructType\_string $contentName = null)
    {
        if (is_null($contentName) || (is_array($contentName) && empty($contentName))) {
            unset($this->contentName);
        } else {
            $this->contentName = $contentName;
        }
        return $this;
    }
    /**
     * Get sourceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getSourceType()
    {
        return isset($this->sourceType) ? $this->sourceType : null;
    }
    /**
     * Set sourceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $sourceType
     * @return \StructType\Mailing
     */
    public function setSourceType(\StructType\_string $sourceType = null)
    {
        if (is_null($sourceType) || (is_array($sourceType) && empty($sourceType))) {
            unset($this->sourceType);
        } else {
            $this->sourceType = $sourceType;
        }
        return $this;
    }
    /**
     * Get sourceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getSourceName()
    {
        return isset($this->sourceName) ? $this->sourceName : null;
    }
    /**
     * Set sourceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $sourceName
     * @return \StructType\Mailing
     */
    public function setSourceName(\StructType\_string $sourceName = null)
    {
        if (is_null($sourceName) || (is_array($sourceName) && empty($sourceName))) {
            unset($this->sourceName);
        } else {
            $this->sourceName = $sourceName;
        }
        return $this;
    }
    /**
     * Get customers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getCustomers()
    {
        return isset($this->customers) ? $this->customers : null;
    }
    /**
     * Set customers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $customers
     * @return \StructType\Mailing
     */
    public function setCustomers(\StructType\Long $customers = null)
    {
        if (is_null($customers) || (is_array($customers) && empty($customers))) {
            unset($this->customers);
        } else {
            $this->customers = $customers;
        }
        return $this;
    }
    /**
     * Get throttle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getThrottle()
    {
        return isset($this->throttle) ? $this->throttle : null;
    }
    /**
     * Set throttle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $throttle
     * @return \StructType\Mailing
     */
    public function setThrottle(\StructType\Long $throttle = null)
    {
        if (is_null($throttle) || (is_array($throttle) && empty($throttle))) {
            unset($this->throttle);
        } else {
            $this->throttle = $throttle;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $status
     * @return \StructType\Mailing
     */
    public function setStatus(\StructType\_string $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Get links value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMailingLink|null
     */
    public function getLinks()
    {
        return isset($this->links) ? $this->links : null;
    }
    /**
     * Set links value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMailingLink $links
     * @return \StructType\Mailing
     */
    public function setLinks(\ArrayType\ArrayOfMailingLink $links = null)
    {
        if (is_null($links) || (is_array($links) && empty($links))) {
            unset($this->links);
        } else {
            $this->links = $links;
        }
        return $this;
    }
    /**
     * Get type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getType()
    {
        return isset($this->type) ? $this->type : null;
    }
    /**
     * Set type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $type
     * @return \StructType\Mailing
     */
    public function setType(\StructType\_string $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->type);
        } else {
            $this->type = $type;
        }
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $description
     * @return \StructType\Mailing
     */
    public function setDescription(\StructType\_string $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get startedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getStartedAt()
    {
        return isset($this->startedAt) ? $this->startedAt : null;
    }
    /**
     * Set startedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $startedAt
     * @return \StructType\Mailing
     */
    public function setStartedAt(\StructType\_string $startedAt = null)
    {
        if (is_null($startedAt) || (is_array($startedAt) && empty($startedAt))) {
            unset($this->startedAt);
        } else {
            $this->startedAt = $startedAt;
        }
        return $this;
    }
    /**
     * Get endedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getEndedAt()
    {
        return isset($this->endedAt) ? $this->endedAt : null;
    }
    /**
     * Set endedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $endedAt
     * @return \StructType\Mailing
     */
    public function setEndedAt(\StructType\_string $endedAt = null)
    {
        if (is_null($endedAt) || (is_array($endedAt) && empty($endedAt))) {
            unset($this->endedAt);
        } else {
            $this->endedAt = $endedAt;
        }
        return $this;
    }
    /**
     * Get bounces value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getBounces()
    {
        return isset($this->bounces) ? $this->bounces : null;
    }
    /**
     * Set bounces value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $bounces
     * @return \StructType\Mailing
     */
    public function setBounces(\StructType\Long $bounces = null)
    {
        if (is_null($bounces) || (is_array($bounces) && empty($bounces))) {
            unset($this->bounces);
        } else {
            $this->bounces = $bounces;
        }
        return $this;
    }
    /**
     * Get opens value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getOpens()
    {
        return isset($this->opens) ? $this->opens : null;
    }
    /**
     * Set opens value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $opens
     * @return \StructType\Mailing
     */
    public function setOpens(\StructType\Long $opens = null)
    {
        if (is_null($opens) || (is_array($opens) && empty($opens))) {
            unset($this->opens);
        } else {
            $this->opens = $opens;
        }
        return $this;
    }
    /**
     * Get clicks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getClicks()
    {
        return isset($this->clicks) ? $this->clicks : null;
    }
    /**
     * Set clicks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $clicks
     * @return \StructType\Mailing
     */
    public function setClicks(\StructType\Long $clicks = null)
    {
        if (is_null($clicks) || (is_array($clicks) && empty($clicks))) {
            unset($this->clicks);
        } else {
            $this->clicks = $clicks;
        }
        return $this;
    }
    /**
     * Get complaints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getComplaints()
    {
        return isset($this->complaints) ? $this->complaints : null;
    }
    /**
     * Set complaints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $complaints
     * @return \StructType\Mailing
     */
    public function setComplaints(\StructType\Long $complaints = null)
    {
        if (is_null($complaints) || (is_array($complaints) && empty($complaints))) {
            unset($this->complaints);
        } else {
            $this->complaints = $complaints;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Mailing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
