<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MagentoOrder StructType
 * @subpackage Structs
 */
class MagentoOrder extends AbstractStructBase
{
    /**
     * The quoteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $quoteId;
    /**
     * The subtotalInclTax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $subtotalInclTax;
    /**
     * The couponCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $couponCode;
    /**
     * The totalQtyOrdered
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $totalQtyOrdered;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $weight;
    /**
     * The taxString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $taxString;
    /**
     * The shippingInclTax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $shippingInclTax;
    /**
     * The discountDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $discountDescription;
    /**
     * The shippingDiscountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $shippingDiscountAmount;
    /**
     * The totalItemCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $totalItemCount;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $status;
    /**
     * The externalOrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $externalOrderId;
    /**
     * The note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $note;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $id;
    /**
     * The storeview
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $storeview;
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $customerId;
    /**
     * The subtotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $subtotal;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $total;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $taxAmount;
    /**
     * The shippingCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $shippingCost;
    /**
     * The discount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $discount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $currency;
    /**
     * The rewardPoints
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $rewardPoints;
    /**
     * The billingFirstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingFirstname;
    /**
     * The billingMiddlename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingMiddlename;
    /**
     * The billingTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingTitle;
    /**
     * The billingLastname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingLastname;
    /**
     * The billingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingAddress;
    /**
     * The billingZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingZipCode;
    /**
     * The billingPoBox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $billingPoBox;
    /**
     * The billingCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingCity;
    /**
     * The billingState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingState;
    /**
     * The billingCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingCountry;
    /**
     * The billingCompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingCompanyName;
    /**
     * The billingPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingPhone;
    /**
     * The billingEmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingEmailAddress;
    /**
     * The shippingFirstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingFirstname;
    /**
     * The shippingMiddlename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingMiddlename;
    /**
     * The shippingTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingTitle;
    /**
     * The shippingLastname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingLastname;
    /**
     * The shippingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingAddress;
    /**
     * The shippingZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingZipCode;
    /**
     * The shippingPoBox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $shippingPoBox;
    /**
     * The shippingCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingCity;
    /**
     * The shippingState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingState;
    /**
     * The shippingCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingCountry;
    /**
     * The shippingCompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingCompanyName;
    /**
     * The shippingPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingPhone;
    /**
     * The paymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $paymentMethod;
    /**
     * The shippingMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingMethod;
    /**
     * The orderDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $orderDate;
    /**
     * The products
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMagentoProduct
     */
    public $products;
    /**
     * The billingPrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingPrefix;
    /**
     * The billingSuffix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $billingSuffix;
    /**
     * The shippingPrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingPrefix;
    /**
     * The shippingSuffix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $shippingSuffix;
    /**
     * Constructor method for MagentoOrder
     * @uses MagentoOrder::setQuoteId()
     * @uses MagentoOrder::setSubtotalInclTax()
     * @uses MagentoOrder::setCouponCode()
     * @uses MagentoOrder::setTotalQtyOrdered()
     * @uses MagentoOrder::setWeight()
     * @uses MagentoOrder::setTaxString()
     * @uses MagentoOrder::setShippingInclTax()
     * @uses MagentoOrder::setDiscountDescription()
     * @uses MagentoOrder::setShippingDiscountAmount()
     * @uses MagentoOrder::setTotalItemCount()
     * @uses MagentoOrder::setStatus()
     * @uses MagentoOrder::setExternalOrderId()
     * @uses MagentoOrder::setNote()
     * @uses MagentoOrder::setId()
     * @uses MagentoOrder::setStoreview()
     * @uses MagentoOrder::setCustomerId()
     * @uses MagentoOrder::setSubtotal()
     * @uses MagentoOrder::setTotal()
     * @uses MagentoOrder::setTaxAmount()
     * @uses MagentoOrder::setShippingCost()
     * @uses MagentoOrder::setDiscount()
     * @uses MagentoOrder::setCurrency()
     * @uses MagentoOrder::setRewardPoints()
     * @uses MagentoOrder::setBillingFirstname()
     * @uses MagentoOrder::setBillingMiddlename()
     * @uses MagentoOrder::setBillingTitle()
     * @uses MagentoOrder::setBillingLastname()
     * @uses MagentoOrder::setBillingAddress()
     * @uses MagentoOrder::setBillingZipCode()
     * @uses MagentoOrder::setBillingPoBox()
     * @uses MagentoOrder::setBillingCity()
     * @uses MagentoOrder::setBillingState()
     * @uses MagentoOrder::setBillingCountry()
     * @uses MagentoOrder::setBillingCompanyName()
     * @uses MagentoOrder::setBillingPhone()
     * @uses MagentoOrder::setBillingEmailAddress()
     * @uses MagentoOrder::setShippingFirstname()
     * @uses MagentoOrder::setShippingMiddlename()
     * @uses MagentoOrder::setShippingTitle()
     * @uses MagentoOrder::setShippingLastname()
     * @uses MagentoOrder::setShippingAddress()
     * @uses MagentoOrder::setShippingZipCode()
     * @uses MagentoOrder::setShippingPoBox()
     * @uses MagentoOrder::setShippingCity()
     * @uses MagentoOrder::setShippingState()
     * @uses MagentoOrder::setShippingCountry()
     * @uses MagentoOrder::setShippingCompanyName()
     * @uses MagentoOrder::setShippingPhone()
     * @uses MagentoOrder::setPaymentMethod()
     * @uses MagentoOrder::setShippingMethod()
     * @uses MagentoOrder::setOrderDate()
     * @uses MagentoOrder::setProducts()
     * @uses MagentoOrder::setBillingPrefix()
     * @uses MagentoOrder::setBillingSuffix()
     * @uses MagentoOrder::setShippingPrefix()
     * @uses MagentoOrder::setShippingSuffix()
     * @param \StructType\_string $quoteId
     * @param \StructType\Double $subtotalInclTax
     * @param \StructType\_string $couponCode
     * @param \StructType\Long $totalQtyOrdered
     * @param \StructType\Double $weight
     * @param \StructType\_string $taxString
     * @param \StructType\Double $shippingInclTax
     * @param \StructType\_string $discountDescription
     * @param \StructType\Double $shippingDiscountAmount
     * @param \StructType\Long $totalItemCount
     * @param \StructType\_string $status
     * @param \StructType\_string $externalOrderId
     * @param \StructType\_string $note
     * @param \StructType\Long $id
     * @param \StructType\_string $storeview
     * @param \StructType\Long $customerId
     * @param \StructType\Double $subtotal
     * @param \StructType\Double $total
     * @param \StructType\Double $taxAmount
     * @param \StructType\Double $shippingCost
     * @param \StructType\Double $discount
     * @param \StructType\_string $currency
     * @param \StructType\Long $rewardPoints
     * @param \StructType\_string $billingFirstname
     * @param \StructType\_string $billingMiddlename
     * @param \StructType\_string $billingTitle
     * @param \StructType\_string $billingLastname
     * @param \StructType\_string $billingAddress
     * @param \StructType\_string $billingZipCode
     * @param \StructType\Long $billingPoBox
     * @param \StructType\_string $billingCity
     * @param \StructType\_string $billingState
     * @param \StructType\_string $billingCountry
     * @param \StructType\_string $billingCompanyName
     * @param \StructType\_string $billingPhone
     * @param \StructType\_string $billingEmailAddress
     * @param \StructType\_string $shippingFirstname
     * @param \StructType\_string $shippingMiddlename
     * @param \StructType\_string $shippingTitle
     * @param \StructType\_string $shippingLastname
     * @param \StructType\_string $shippingAddress
     * @param \StructType\_string $shippingZipCode
     * @param \StructType\Long $shippingPoBox
     * @param \StructType\_string $shippingCity
     * @param \StructType\_string $shippingState
     * @param \StructType\_string $shippingCountry
     * @param \StructType\_string $shippingCompanyName
     * @param \StructType\_string $shippingPhone
     * @param \StructType\_string $paymentMethod
     * @param \StructType\_string $shippingMethod
     * @param \StructType\Long $orderDate
     * @param \ArrayType\ArrayOfMagentoProduct $products
     * @param \StructType\_string $billingPrefix
     * @param \StructType\_string $billingSuffix
     * @param \StructType\_string $shippingPrefix
     * @param \StructType\_string $shippingSuffix
     */
    public function __construct(\StructType\_string $quoteId = null, \StructType\Double $subtotalInclTax = null, \StructType\_string $couponCode = null, \StructType\Long $totalQtyOrdered = null, \StructType\Double $weight = null, \StructType\_string $taxString = null, \StructType\Double $shippingInclTax = null, \StructType\_string $discountDescription = null, \StructType\Double $shippingDiscountAmount = null, \StructType\Long $totalItemCount = null, \StructType\_string $status = null, \StructType\_string $externalOrderId = null, \StructType\_string $note = null, \StructType\Long $id = null, \StructType\_string $storeview = null, \StructType\Long $customerId = null, \StructType\Double $subtotal = null, \StructType\Double $total = null, \StructType\Double $taxAmount = null, \StructType\Double $shippingCost = null, \StructType\Double $discount = null, \StructType\_string $currency = null, \StructType\Long $rewardPoints = null, \StructType\_string $billingFirstname = null, \StructType\_string $billingMiddlename = null, \StructType\_string $billingTitle = null, \StructType\_string $billingLastname = null, \StructType\_string $billingAddress = null, \StructType\_string $billingZipCode = null, \StructType\Long $billingPoBox = null, \StructType\_string $billingCity = null, \StructType\_string $billingState = null, \StructType\_string $billingCountry = null, \StructType\_string $billingCompanyName = null, \StructType\_string $billingPhone = null, \StructType\_string $billingEmailAddress = null, \StructType\_string $shippingFirstname = null, \StructType\_string $shippingMiddlename = null, \StructType\_string $shippingTitle = null, \StructType\_string $shippingLastname = null, \StructType\_string $shippingAddress = null, \StructType\_string $shippingZipCode = null, \StructType\Long $shippingPoBox = null, \StructType\_string $shippingCity = null, \StructType\_string $shippingState = null, \StructType\_string $shippingCountry = null, \StructType\_string $shippingCompanyName = null, \StructType\_string $shippingPhone = null, \StructType\_string $paymentMethod = null, \StructType\_string $shippingMethod = null, \StructType\Long $orderDate = null, \ArrayType\ArrayOfMagentoProduct $products = null, \StructType\_string $billingPrefix = null, \StructType\_string $billingSuffix = null, \StructType\_string $shippingPrefix = null, \StructType\_string $shippingSuffix = null)
    {
        $this
            ->setQuoteId($quoteId)
            ->setSubtotalInclTax($subtotalInclTax)
            ->setCouponCode($couponCode)
            ->setTotalQtyOrdered($totalQtyOrdered)
            ->setWeight($weight)
            ->setTaxString($taxString)
            ->setShippingInclTax($shippingInclTax)
            ->setDiscountDescription($discountDescription)
            ->setShippingDiscountAmount($shippingDiscountAmount)
            ->setTotalItemCount($totalItemCount)
            ->setStatus($status)
            ->setExternalOrderId($externalOrderId)
            ->setNote($note)
            ->setId($id)
            ->setStoreview($storeview)
            ->setCustomerId($customerId)
            ->setSubtotal($subtotal)
            ->setTotal($total)
            ->setTaxAmount($taxAmount)
            ->setShippingCost($shippingCost)
            ->setDiscount($discount)
            ->setCurrency($currency)
            ->setRewardPoints($rewardPoints)
            ->setBillingFirstname($billingFirstname)
            ->setBillingMiddlename($billingMiddlename)
            ->setBillingTitle($billingTitle)
            ->setBillingLastname($billingLastname)
            ->setBillingAddress($billingAddress)
            ->setBillingZipCode($billingZipCode)
            ->setBillingPoBox($billingPoBox)
            ->setBillingCity($billingCity)
            ->setBillingState($billingState)
            ->setBillingCountry($billingCountry)
            ->setBillingCompanyName($billingCompanyName)
            ->setBillingPhone($billingPhone)
            ->setBillingEmailAddress($billingEmailAddress)
            ->setShippingFirstname($shippingFirstname)
            ->setShippingMiddlename($shippingMiddlename)
            ->setShippingTitle($shippingTitle)
            ->setShippingLastname($shippingLastname)
            ->setShippingAddress($shippingAddress)
            ->setShippingZipCode($shippingZipCode)
            ->setShippingPoBox($shippingPoBox)
            ->setShippingCity($shippingCity)
            ->setShippingState($shippingState)
            ->setShippingCountry($shippingCountry)
            ->setShippingCompanyName($shippingCompanyName)
            ->setShippingPhone($shippingPhone)
            ->setPaymentMethod($paymentMethod)
            ->setShippingMethod($shippingMethod)
            ->setOrderDate($orderDate)
            ->setProducts($products)
            ->setBillingPrefix($billingPrefix)
            ->setBillingSuffix($billingSuffix)
            ->setShippingPrefix($shippingPrefix)
            ->setShippingSuffix($shippingSuffix);
    }
    /**
     * Get quoteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getQuoteId()
    {
        return isset($this->quoteId) ? $this->quoteId : null;
    }
    /**
     * Set quoteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $quoteId
     * @return \StructType\MagentoOrder
     */
    public function setQuoteId(\StructType\_string $quoteId = null)
    {
        if (is_null($quoteId) || (is_array($quoteId) && empty($quoteId))) {
            unset($this->quoteId);
        } else {
            $this->quoteId = $quoteId;
        }
        return $this;
    }
    /**
     * Get subtotalInclTax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getSubtotalInclTax()
    {
        return isset($this->subtotalInclTax) ? $this->subtotalInclTax : null;
    }
    /**
     * Set subtotalInclTax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $subtotalInclTax
     * @return \StructType\MagentoOrder
     */
    public function setSubtotalInclTax(\StructType\Double $subtotalInclTax = null)
    {
        if (is_null($subtotalInclTax) || (is_array($subtotalInclTax) && empty($subtotalInclTax))) {
            unset($this->subtotalInclTax);
        } else {
            $this->subtotalInclTax = $subtotalInclTax;
        }
        return $this;
    }
    /**
     * Get couponCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getCouponCode()
    {
        return isset($this->couponCode) ? $this->couponCode : null;
    }
    /**
     * Set couponCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $couponCode
     * @return \StructType\MagentoOrder
     */
    public function setCouponCode(\StructType\_string $couponCode = null)
    {
        if (is_null($couponCode) || (is_array($couponCode) && empty($couponCode))) {
            unset($this->couponCode);
        } else {
            $this->couponCode = $couponCode;
        }
        return $this;
    }
    /**
     * Get totalQtyOrdered value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getTotalQtyOrdered()
    {
        return isset($this->totalQtyOrdered) ? $this->totalQtyOrdered : null;
    }
    /**
     * Set totalQtyOrdered value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $totalQtyOrdered
     * @return \StructType\MagentoOrder
     */
    public function setTotalQtyOrdered(\StructType\Long $totalQtyOrdered = null)
    {
        if (is_null($totalQtyOrdered) || (is_array($totalQtyOrdered) && empty($totalQtyOrdered))) {
            unset($this->totalQtyOrdered);
        } else {
            $this->totalQtyOrdered = $totalQtyOrdered;
        }
        return $this;
    }
    /**
     * Get weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getWeight()
    {
        return isset($this->weight) ? $this->weight : null;
    }
    /**
     * Set weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $weight
     * @return \StructType\MagentoOrder
     */
    public function setWeight(\StructType\Double $weight = null)
    {
        if (is_null($weight) || (is_array($weight) && empty($weight))) {
            unset($this->weight);
        } else {
            $this->weight = $weight;
        }
        return $this;
    }
    /**
     * Get taxString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getTaxString()
    {
        return isset($this->taxString) ? $this->taxString : null;
    }
    /**
     * Set taxString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $taxString
     * @return \StructType\MagentoOrder
     */
    public function setTaxString(\StructType\_string $taxString = null)
    {
        if (is_null($taxString) || (is_array($taxString) && empty($taxString))) {
            unset($this->taxString);
        } else {
            $this->taxString = $taxString;
        }
        return $this;
    }
    /**
     * Get shippingInclTax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getShippingInclTax()
    {
        return isset($this->shippingInclTax) ? $this->shippingInclTax : null;
    }
    /**
     * Set shippingInclTax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $shippingInclTax
     * @return \StructType\MagentoOrder
     */
    public function setShippingInclTax(\StructType\Double $shippingInclTax = null)
    {
        if (is_null($shippingInclTax) || (is_array($shippingInclTax) && empty($shippingInclTax))) {
            unset($this->shippingInclTax);
        } else {
            $this->shippingInclTax = $shippingInclTax;
        }
        return $this;
    }
    /**
     * Get discountDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getDiscountDescription()
    {
        return isset($this->discountDescription) ? $this->discountDescription : null;
    }
    /**
     * Set discountDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $discountDescription
     * @return \StructType\MagentoOrder
     */
    public function setDiscountDescription(\StructType\_string $discountDescription = null)
    {
        if (is_null($discountDescription) || (is_array($discountDescription) && empty($discountDescription))) {
            unset($this->discountDescription);
        } else {
            $this->discountDescription = $discountDescription;
        }
        return $this;
    }
    /**
     * Get shippingDiscountAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getShippingDiscountAmount()
    {
        return isset($this->shippingDiscountAmount) ? $this->shippingDiscountAmount : null;
    }
    /**
     * Set shippingDiscountAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $shippingDiscountAmount
     * @return \StructType\MagentoOrder
     */
    public function setShippingDiscountAmount(\StructType\Double $shippingDiscountAmount = null)
    {
        if (is_null($shippingDiscountAmount) || (is_array($shippingDiscountAmount) && empty($shippingDiscountAmount))) {
            unset($this->shippingDiscountAmount);
        } else {
            $this->shippingDiscountAmount = $shippingDiscountAmount;
        }
        return $this;
    }
    /**
     * Get totalItemCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getTotalItemCount()
    {
        return isset($this->totalItemCount) ? $this->totalItemCount : null;
    }
    /**
     * Set totalItemCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $totalItemCount
     * @return \StructType\MagentoOrder
     */
    public function setTotalItemCount(\StructType\Long $totalItemCount = null)
    {
        if (is_null($totalItemCount) || (is_array($totalItemCount) && empty($totalItemCount))) {
            unset($this->totalItemCount);
        } else {
            $this->totalItemCount = $totalItemCount;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $status
     * @return \StructType\MagentoOrder
     */
    public function setStatus(\StructType\_string $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Get externalOrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getExternalOrderId()
    {
        return isset($this->externalOrderId) ? $this->externalOrderId : null;
    }
    /**
     * Set externalOrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $externalOrderId
     * @return \StructType\MagentoOrder
     */
    public function setExternalOrderId(\StructType\_string $externalOrderId = null)
    {
        if (is_null($externalOrderId) || (is_array($externalOrderId) && empty($externalOrderId))) {
            unset($this->externalOrderId);
        } else {
            $this->externalOrderId = $externalOrderId;
        }
        return $this;
    }
    /**
     * Get note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getNote()
    {
        return isset($this->note) ? $this->note : null;
    }
    /**
     * Set note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $note
     * @return \StructType\MagentoOrder
     */
    public function setNote(\StructType\_string $note = null)
    {
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->note);
        } else {
            $this->note = $note;
        }
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $id
     * @return \StructType\MagentoOrder
     */
    public function setId(\StructType\Long $id = null)
    {
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get storeview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getStoreview()
    {
        return isset($this->storeview) ? $this->storeview : null;
    }
    /**
     * Set storeview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $storeview
     * @return \StructType\MagentoOrder
     */
    public function setStoreview(\StructType\_string $storeview = null)
    {
        if (is_null($storeview) || (is_array($storeview) && empty($storeview))) {
            unset($this->storeview);
        } else {
            $this->storeview = $storeview;
        }
        return $this;
    }
    /**
     * Get customerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getCustomerId()
    {
        return isset($this->customerId) ? $this->customerId : null;
    }
    /**
     * Set customerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $customerId
     * @return \StructType\MagentoOrder
     */
    public function setCustomerId(\StructType\Long $customerId = null)
    {
        if (is_null($customerId) || (is_array($customerId) && empty($customerId))) {
            unset($this->customerId);
        } else {
            $this->customerId = $customerId;
        }
        return $this;
    }
    /**
     * Get subtotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getSubtotal()
    {
        return isset($this->subtotal) ? $this->subtotal : null;
    }
    /**
     * Set subtotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $subtotal
     * @return \StructType\MagentoOrder
     */
    public function setSubtotal(\StructType\Double $subtotal = null)
    {
        if (is_null($subtotal) || (is_array($subtotal) && empty($subtotal))) {
            unset($this->subtotal);
        } else {
            $this->subtotal = $subtotal;
        }
        return $this;
    }
    /**
     * Get total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getTotal()
    {
        return isset($this->total) ? $this->total : null;
    }
    /**
     * Set total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $total
     * @return \StructType\MagentoOrder
     */
    public function setTotal(\StructType\Double $total = null)
    {
        if (is_null($total) || (is_array($total) && empty($total))) {
            unset($this->total);
        } else {
            $this->total = $total;
        }
        return $this;
    }
    /**
     * Get taxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getTaxAmount()
    {
        return isset($this->taxAmount) ? $this->taxAmount : null;
    }
    /**
     * Set taxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $taxAmount
     * @return \StructType\MagentoOrder
     */
    public function setTaxAmount(\StructType\Double $taxAmount = null)
    {
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->taxAmount);
        } else {
            $this->taxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Get shippingCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getShippingCost()
    {
        return isset($this->shippingCost) ? $this->shippingCost : null;
    }
    /**
     * Set shippingCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $shippingCost
     * @return \StructType\MagentoOrder
     */
    public function setShippingCost(\StructType\Double $shippingCost = null)
    {
        if (is_null($shippingCost) || (is_array($shippingCost) && empty($shippingCost))) {
            unset($this->shippingCost);
        } else {
            $this->shippingCost = $shippingCost;
        }
        return $this;
    }
    /**
     * Get discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getDiscount()
    {
        return isset($this->discount) ? $this->discount : null;
    }
    /**
     * Set discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $discount
     * @return \StructType\MagentoOrder
     */
    public function setDiscount(\StructType\Double $discount = null)
    {
        if (is_null($discount) || (is_array($discount) && empty($discount))) {
            unset($this->discount);
        } else {
            $this->discount = $discount;
        }
        return $this;
    }
    /**
     * Get currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getCurrency()
    {
        return isset($this->currency) ? $this->currency : null;
    }
    /**
     * Set currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $currency
     * @return \StructType\MagentoOrder
     */
    public function setCurrency(\StructType\_string $currency = null)
    {
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->currency);
        } else {
            $this->currency = $currency;
        }
        return $this;
    }
    /**
     * Get rewardPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getRewardPoints()
    {
        return isset($this->rewardPoints) ? $this->rewardPoints : null;
    }
    /**
     * Set rewardPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $rewardPoints
     * @return \StructType\MagentoOrder
     */
    public function setRewardPoints(\StructType\Long $rewardPoints = null)
    {
        if (is_null($rewardPoints) || (is_array($rewardPoints) && empty($rewardPoints))) {
            unset($this->rewardPoints);
        } else {
            $this->rewardPoints = $rewardPoints;
        }
        return $this;
    }
    /**
     * Get billingFirstname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingFirstname()
    {
        return isset($this->billingFirstname) ? $this->billingFirstname : null;
    }
    /**
     * Set billingFirstname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingFirstname
     * @return \StructType\MagentoOrder
     */
    public function setBillingFirstname(\StructType\_string $billingFirstname = null)
    {
        if (is_null($billingFirstname) || (is_array($billingFirstname) && empty($billingFirstname))) {
            unset($this->billingFirstname);
        } else {
            $this->billingFirstname = $billingFirstname;
        }
        return $this;
    }
    /**
     * Get billingMiddlename value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingMiddlename()
    {
        return isset($this->billingMiddlename) ? $this->billingMiddlename : null;
    }
    /**
     * Set billingMiddlename value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingMiddlename
     * @return \StructType\MagentoOrder
     */
    public function setBillingMiddlename(\StructType\_string $billingMiddlename = null)
    {
        if (is_null($billingMiddlename) || (is_array($billingMiddlename) && empty($billingMiddlename))) {
            unset($this->billingMiddlename);
        } else {
            $this->billingMiddlename = $billingMiddlename;
        }
        return $this;
    }
    /**
     * Get billingTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingTitle()
    {
        return isset($this->billingTitle) ? $this->billingTitle : null;
    }
    /**
     * Set billingTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingTitle
     * @return \StructType\MagentoOrder
     */
    public function setBillingTitle(\StructType\_string $billingTitle = null)
    {
        if (is_null($billingTitle) || (is_array($billingTitle) && empty($billingTitle))) {
            unset($this->billingTitle);
        } else {
            $this->billingTitle = $billingTitle;
        }
        return $this;
    }
    /**
     * Get billingLastname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingLastname()
    {
        return isset($this->billingLastname) ? $this->billingLastname : null;
    }
    /**
     * Set billingLastname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingLastname
     * @return \StructType\MagentoOrder
     */
    public function setBillingLastname(\StructType\_string $billingLastname = null)
    {
        if (is_null($billingLastname) || (is_array($billingLastname) && empty($billingLastname))) {
            unset($this->billingLastname);
        } else {
            $this->billingLastname = $billingLastname;
        }
        return $this;
    }
    /**
     * Get billingAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingAddress()
    {
        return isset($this->billingAddress) ? $this->billingAddress : null;
    }
    /**
     * Set billingAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingAddress
     * @return \StructType\MagentoOrder
     */
    public function setBillingAddress(\StructType\_string $billingAddress = null)
    {
        if (is_null($billingAddress) || (is_array($billingAddress) && empty($billingAddress))) {
            unset($this->billingAddress);
        } else {
            $this->billingAddress = $billingAddress;
        }
        return $this;
    }
    /**
     * Get billingZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingZipCode()
    {
        return isset($this->billingZipCode) ? $this->billingZipCode : null;
    }
    /**
     * Set billingZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingZipCode
     * @return \StructType\MagentoOrder
     */
    public function setBillingZipCode(\StructType\_string $billingZipCode = null)
    {
        if (is_null($billingZipCode) || (is_array($billingZipCode) && empty($billingZipCode))) {
            unset($this->billingZipCode);
        } else {
            $this->billingZipCode = $billingZipCode;
        }
        return $this;
    }
    /**
     * Get billingPoBox value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getBillingPoBox()
    {
        return isset($this->billingPoBox) ? $this->billingPoBox : null;
    }
    /**
     * Set billingPoBox value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $billingPoBox
     * @return \StructType\MagentoOrder
     */
    public function setBillingPoBox(\StructType\Long $billingPoBox = null)
    {
        if (is_null($billingPoBox) || (is_array($billingPoBox) && empty($billingPoBox))) {
            unset($this->billingPoBox);
        } else {
            $this->billingPoBox = $billingPoBox;
        }
        return $this;
    }
    /**
     * Get billingCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingCity()
    {
        return isset($this->billingCity) ? $this->billingCity : null;
    }
    /**
     * Set billingCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingCity
     * @return \StructType\MagentoOrder
     */
    public function setBillingCity(\StructType\_string $billingCity = null)
    {
        if (is_null($billingCity) || (is_array($billingCity) && empty($billingCity))) {
            unset($this->billingCity);
        } else {
            $this->billingCity = $billingCity;
        }
        return $this;
    }
    /**
     * Get billingState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingState()
    {
        return isset($this->billingState) ? $this->billingState : null;
    }
    /**
     * Set billingState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingState
     * @return \StructType\MagentoOrder
     */
    public function setBillingState(\StructType\_string $billingState = null)
    {
        if (is_null($billingState) || (is_array($billingState) && empty($billingState))) {
            unset($this->billingState);
        } else {
            $this->billingState = $billingState;
        }
        return $this;
    }
    /**
     * Get billingCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingCountry()
    {
        return isset($this->billingCountry) ? $this->billingCountry : null;
    }
    /**
     * Set billingCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingCountry
     * @return \StructType\MagentoOrder
     */
    public function setBillingCountry(\StructType\_string $billingCountry = null)
    {
        if (is_null($billingCountry) || (is_array($billingCountry) && empty($billingCountry))) {
            unset($this->billingCountry);
        } else {
            $this->billingCountry = $billingCountry;
        }
        return $this;
    }
    /**
     * Get billingCompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingCompanyName()
    {
        return isset($this->billingCompanyName) ? $this->billingCompanyName : null;
    }
    /**
     * Set billingCompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingCompanyName
     * @return \StructType\MagentoOrder
     */
    public function setBillingCompanyName(\StructType\_string $billingCompanyName = null)
    {
        if (is_null($billingCompanyName) || (is_array($billingCompanyName) && empty($billingCompanyName))) {
            unset($this->billingCompanyName);
        } else {
            $this->billingCompanyName = $billingCompanyName;
        }
        return $this;
    }
    /**
     * Get billingPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingPhone()
    {
        return isset($this->billingPhone) ? $this->billingPhone : null;
    }
    /**
     * Set billingPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingPhone
     * @return \StructType\MagentoOrder
     */
    public function setBillingPhone(\StructType\_string $billingPhone = null)
    {
        if (is_null($billingPhone) || (is_array($billingPhone) && empty($billingPhone))) {
            unset($this->billingPhone);
        } else {
            $this->billingPhone = $billingPhone;
        }
        return $this;
    }
    /**
     * Get billingEmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingEmailAddress()
    {
        return isset($this->billingEmailAddress) ? $this->billingEmailAddress : null;
    }
    /**
     * Set billingEmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingEmailAddress
     * @return \StructType\MagentoOrder
     */
    public function setBillingEmailAddress(\StructType\_string $billingEmailAddress = null)
    {
        if (is_null($billingEmailAddress) || (is_array($billingEmailAddress) && empty($billingEmailAddress))) {
            unset($this->billingEmailAddress);
        } else {
            $this->billingEmailAddress = $billingEmailAddress;
        }
        return $this;
    }
    /**
     * Get shippingFirstname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingFirstname()
    {
        return isset($this->shippingFirstname) ? $this->shippingFirstname : null;
    }
    /**
     * Set shippingFirstname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingFirstname
     * @return \StructType\MagentoOrder
     */
    public function setShippingFirstname(\StructType\_string $shippingFirstname = null)
    {
        if (is_null($shippingFirstname) || (is_array($shippingFirstname) && empty($shippingFirstname))) {
            unset($this->shippingFirstname);
        } else {
            $this->shippingFirstname = $shippingFirstname;
        }
        return $this;
    }
    /**
     * Get shippingMiddlename value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingMiddlename()
    {
        return isset($this->shippingMiddlename) ? $this->shippingMiddlename : null;
    }
    /**
     * Set shippingMiddlename value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingMiddlename
     * @return \StructType\MagentoOrder
     */
    public function setShippingMiddlename(\StructType\_string $shippingMiddlename = null)
    {
        if (is_null($shippingMiddlename) || (is_array($shippingMiddlename) && empty($shippingMiddlename))) {
            unset($this->shippingMiddlename);
        } else {
            $this->shippingMiddlename = $shippingMiddlename;
        }
        return $this;
    }
    /**
     * Get shippingTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingTitle()
    {
        return isset($this->shippingTitle) ? $this->shippingTitle : null;
    }
    /**
     * Set shippingTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingTitle
     * @return \StructType\MagentoOrder
     */
    public function setShippingTitle(\StructType\_string $shippingTitle = null)
    {
        if (is_null($shippingTitle) || (is_array($shippingTitle) && empty($shippingTitle))) {
            unset($this->shippingTitle);
        } else {
            $this->shippingTitle = $shippingTitle;
        }
        return $this;
    }
    /**
     * Get shippingLastname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingLastname()
    {
        return isset($this->shippingLastname) ? $this->shippingLastname : null;
    }
    /**
     * Set shippingLastname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingLastname
     * @return \StructType\MagentoOrder
     */
    public function setShippingLastname(\StructType\_string $shippingLastname = null)
    {
        if (is_null($shippingLastname) || (is_array($shippingLastname) && empty($shippingLastname))) {
            unset($this->shippingLastname);
        } else {
            $this->shippingLastname = $shippingLastname;
        }
        return $this;
    }
    /**
     * Get shippingAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingAddress()
    {
        return isset($this->shippingAddress) ? $this->shippingAddress : null;
    }
    /**
     * Set shippingAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingAddress
     * @return \StructType\MagentoOrder
     */
    public function setShippingAddress(\StructType\_string $shippingAddress = null)
    {
        if (is_null($shippingAddress) || (is_array($shippingAddress) && empty($shippingAddress))) {
            unset($this->shippingAddress);
        } else {
            $this->shippingAddress = $shippingAddress;
        }
        return $this;
    }
    /**
     * Get shippingZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingZipCode()
    {
        return isset($this->shippingZipCode) ? $this->shippingZipCode : null;
    }
    /**
     * Set shippingZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingZipCode
     * @return \StructType\MagentoOrder
     */
    public function setShippingZipCode(\StructType\_string $shippingZipCode = null)
    {
        if (is_null($shippingZipCode) || (is_array($shippingZipCode) && empty($shippingZipCode))) {
            unset($this->shippingZipCode);
        } else {
            $this->shippingZipCode = $shippingZipCode;
        }
        return $this;
    }
    /**
     * Get shippingPoBox value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getShippingPoBox()
    {
        return isset($this->shippingPoBox) ? $this->shippingPoBox : null;
    }
    /**
     * Set shippingPoBox value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $shippingPoBox
     * @return \StructType\MagentoOrder
     */
    public function setShippingPoBox(\StructType\Long $shippingPoBox = null)
    {
        if (is_null($shippingPoBox) || (is_array($shippingPoBox) && empty($shippingPoBox))) {
            unset($this->shippingPoBox);
        } else {
            $this->shippingPoBox = $shippingPoBox;
        }
        return $this;
    }
    /**
     * Get shippingCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingCity()
    {
        return isset($this->shippingCity) ? $this->shippingCity : null;
    }
    /**
     * Set shippingCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingCity
     * @return \StructType\MagentoOrder
     */
    public function setShippingCity(\StructType\_string $shippingCity = null)
    {
        if (is_null($shippingCity) || (is_array($shippingCity) && empty($shippingCity))) {
            unset($this->shippingCity);
        } else {
            $this->shippingCity = $shippingCity;
        }
        return $this;
    }
    /**
     * Get shippingState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingState()
    {
        return isset($this->shippingState) ? $this->shippingState : null;
    }
    /**
     * Set shippingState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingState
     * @return \StructType\MagentoOrder
     */
    public function setShippingState(\StructType\_string $shippingState = null)
    {
        if (is_null($shippingState) || (is_array($shippingState) && empty($shippingState))) {
            unset($this->shippingState);
        } else {
            $this->shippingState = $shippingState;
        }
        return $this;
    }
    /**
     * Get shippingCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingCountry()
    {
        return isset($this->shippingCountry) ? $this->shippingCountry : null;
    }
    /**
     * Set shippingCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingCountry
     * @return \StructType\MagentoOrder
     */
    public function setShippingCountry(\StructType\_string $shippingCountry = null)
    {
        if (is_null($shippingCountry) || (is_array($shippingCountry) && empty($shippingCountry))) {
            unset($this->shippingCountry);
        } else {
            $this->shippingCountry = $shippingCountry;
        }
        return $this;
    }
    /**
     * Get shippingCompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingCompanyName()
    {
        return isset($this->shippingCompanyName) ? $this->shippingCompanyName : null;
    }
    /**
     * Set shippingCompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingCompanyName
     * @return \StructType\MagentoOrder
     */
    public function setShippingCompanyName(\StructType\_string $shippingCompanyName = null)
    {
        if (is_null($shippingCompanyName) || (is_array($shippingCompanyName) && empty($shippingCompanyName))) {
            unset($this->shippingCompanyName);
        } else {
            $this->shippingCompanyName = $shippingCompanyName;
        }
        return $this;
    }
    /**
     * Get shippingPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingPhone()
    {
        return isset($this->shippingPhone) ? $this->shippingPhone : null;
    }
    /**
     * Set shippingPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingPhone
     * @return \StructType\MagentoOrder
     */
    public function setShippingPhone(\StructType\_string $shippingPhone = null)
    {
        if (is_null($shippingPhone) || (is_array($shippingPhone) && empty($shippingPhone))) {
            unset($this->shippingPhone);
        } else {
            $this->shippingPhone = $shippingPhone;
        }
        return $this;
    }
    /**
     * Get paymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getPaymentMethod()
    {
        return isset($this->paymentMethod) ? $this->paymentMethod : null;
    }
    /**
     * Set paymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $paymentMethod
     * @return \StructType\MagentoOrder
     */
    public function setPaymentMethod(\StructType\_string $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->paymentMethod);
        } else {
            $this->paymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get shippingMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingMethod()
    {
        return isset($this->shippingMethod) ? $this->shippingMethod : null;
    }
    /**
     * Set shippingMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingMethod
     * @return \StructType\MagentoOrder
     */
    public function setShippingMethod(\StructType\_string $shippingMethod = null)
    {
        if (is_null($shippingMethod) || (is_array($shippingMethod) && empty($shippingMethod))) {
            unset($this->shippingMethod);
        } else {
            $this->shippingMethod = $shippingMethod;
        }
        return $this;
    }
    /**
     * Get orderDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getOrderDate()
    {
        return isset($this->orderDate) ? $this->orderDate : null;
    }
    /**
     * Set orderDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $orderDate
     * @return \StructType\MagentoOrder
     */
    public function setOrderDate(\StructType\Long $orderDate = null)
    {
        if (is_null($orderDate) || (is_array($orderDate) && empty($orderDate))) {
            unset($this->orderDate);
        } else {
            $this->orderDate = $orderDate;
        }
        return $this;
    }
    /**
     * Get products value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMagentoProduct|null
     */
    public function getProducts()
    {
        return isset($this->products) ? $this->products : null;
    }
    /**
     * Set products value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMagentoProduct $products
     * @return \StructType\MagentoOrder
     */
    public function setProducts(\ArrayType\ArrayOfMagentoProduct $products = null)
    {
        if (is_null($products) || (is_array($products) && empty($products))) {
            unset($this->products);
        } else {
            $this->products = $products;
        }
        return $this;
    }
    /**
     * Get billingPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingPrefix()
    {
        return isset($this->billingPrefix) ? $this->billingPrefix : null;
    }
    /**
     * Set billingPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingPrefix
     * @return \StructType\MagentoOrder
     */
    public function setBillingPrefix(\StructType\_string $billingPrefix = null)
    {
        if (is_null($billingPrefix) || (is_array($billingPrefix) && empty($billingPrefix))) {
            unset($this->billingPrefix);
        } else {
            $this->billingPrefix = $billingPrefix;
        }
        return $this;
    }
    /**
     * Get billingSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getBillingSuffix()
    {
        return isset($this->billingSuffix) ? $this->billingSuffix : null;
    }
    /**
     * Set billingSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $billingSuffix
     * @return \StructType\MagentoOrder
     */
    public function setBillingSuffix(\StructType\_string $billingSuffix = null)
    {
        if (is_null($billingSuffix) || (is_array($billingSuffix) && empty($billingSuffix))) {
            unset($this->billingSuffix);
        } else {
            $this->billingSuffix = $billingSuffix;
        }
        return $this;
    }
    /**
     * Get shippingPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingPrefix()
    {
        return isset($this->shippingPrefix) ? $this->shippingPrefix : null;
    }
    /**
     * Set shippingPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingPrefix
     * @return \StructType\MagentoOrder
     */
    public function setShippingPrefix(\StructType\_string $shippingPrefix = null)
    {
        if (is_null($shippingPrefix) || (is_array($shippingPrefix) && empty($shippingPrefix))) {
            unset($this->shippingPrefix);
        } else {
            $this->shippingPrefix = $shippingPrefix;
        }
        return $this;
    }
    /**
     * Get shippingSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getShippingSuffix()
    {
        return isset($this->shippingSuffix) ? $this->shippingSuffix : null;
    }
    /**
     * Set shippingSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $shippingSuffix
     * @return \StructType\MagentoOrder
     */
    public function setShippingSuffix(\StructType\_string $shippingSuffix = null)
    {
        if (is_null($shippingSuffix) || (is_array($shippingSuffix) && empty($shippingSuffix))) {
            unset($this->shippingSuffix);
        } else {
            $this->shippingSuffix = $shippingSuffix;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MagentoOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
