<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for group_upsert StructType
 * @subpackage Structs
 */
class Group_upsert extends AbstractStructBase
{
    /**
     * The uuid
     * @var \StructType\_string
     */
    public $uuid;
    /**
     * The group
     * @var \StructType\Group
     */
    public $group;
    /**
     * Constructor method for group_upsert
     * @uses Group_upsert::setUuid()
     * @uses Group_upsert::setGroup()
     * @param \StructType\_string $uuid
     * @param \StructType\Group $group
     */
    public function __construct(\StructType\_string $uuid = null, \StructType\Group $group = null)
    {
        $this
            ->setUuid($uuid)
            ->setGroup($group);
    }
    /**
     * Get uuid value
     * @return \StructType\_string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param \StructType\_string $uuid
     * @return \StructType\Group_upsert
     */
    public function setUuid(\StructType\_string $uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get group value
     * @return \StructType\Group|null
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * Set group value
     * @param \StructType\Group $group
     * @return \StructType\Group_upsert
     */
    public function setGroup(\StructType\Group $group = null)
    {
        $this->group = $group;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Group_upsert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
