<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Click StructType
 * @subpackage Structs
 */
class Click extends AbstractStructBase
{
    /**
     * The link
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MailingLink
     */
    public $link;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $id;
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $customerId;
    /**
     * The mailingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $mailingId;
    /**
     * The clickedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $clickedAt;
    /**
     * The browserInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BrowserInformation
     */
    public $browserInformation;
    /**
     * Constructor method for Click
     * @uses Click::setLink()
     * @uses Click::setId()
     * @uses Click::setCustomerId()
     * @uses Click::setMailingId()
     * @uses Click::setClickedAt()
     * @uses Click::setBrowserInformation()
     * @param \StructType\MailingLink $link
     * @param \StructType\Long $id
     * @param \StructType\Long $customerId
     * @param \StructType\Long $mailingId
     * @param \StructType\_string $clickedAt
     * @param \StructType\BrowserInformation $browserInformation
     */
    public function __construct(\StructType\MailingLink $link = null, \StructType\Long $id = null, \StructType\Long $customerId = null, \StructType\Long $mailingId = null, \StructType\_string $clickedAt = null, \StructType\BrowserInformation $browserInformation = null)
    {
        $this
            ->setLink($link)
            ->setId($id)
            ->setCustomerId($customerId)
            ->setMailingId($mailingId)
            ->setClickedAt($clickedAt)
            ->setBrowserInformation($browserInformation);
    }
    /**
     * Get link value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MailingLink|null
     */
    public function getLink()
    {
        return isset($this->link) ? $this->link : null;
    }
    /**
     * Set link value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\MailingLink $link
     * @return \StructType\Click
     */
    public function setLink(\StructType\MailingLink $link = null)
    {
        if (is_null($link) || (is_array($link) && empty($link))) {
            unset($this->link);
        } else {
            $this->link = $link;
        }
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $id
     * @return \StructType\Click
     */
    public function setId(\StructType\Long $id = null)
    {
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get customerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getCustomerId()
    {
        return isset($this->customerId) ? $this->customerId : null;
    }
    /**
     * Set customerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $customerId
     * @return \StructType\Click
     */
    public function setCustomerId(\StructType\Long $customerId = null)
    {
        if (is_null($customerId) || (is_array($customerId) && empty($customerId))) {
            unset($this->customerId);
        } else {
            $this->customerId = $customerId;
        }
        return $this;
    }
    /**
     * Get mailingId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getMailingId()
    {
        return isset($this->mailingId) ? $this->mailingId : null;
    }
    /**
     * Set mailingId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $mailingId
     * @return \StructType\Click
     */
    public function setMailingId(\StructType\Long $mailingId = null)
    {
        if (is_null($mailingId) || (is_array($mailingId) && empty($mailingId))) {
            unset($this->mailingId);
        } else {
            $this->mailingId = $mailingId;
        }
        return $this;
    }
    /**
     * Get clickedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getClickedAt()
    {
        return isset($this->clickedAt) ? $this->clickedAt : null;
    }
    /**
     * Set clickedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $clickedAt
     * @return \StructType\Click
     */
    public function setClickedAt(\StructType\_string $clickedAt = null)
    {
        if (is_null($clickedAt) || (is_array($clickedAt) && empty($clickedAt))) {
            unset($this->clickedAt);
        } else {
            $this->clickedAt = $clickedAt;
        }
        return $this;
    }
    /**
     * Get browserInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BrowserInformation|null
     */
    public function getBrowserInformation()
    {
        return isset($this->browserInformation) ? $this->browserInformation : null;
    }
    /**
     * Set browserInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BrowserInformation $browserInformation
     * @return \StructType\Click
     */
    public function setBrowserInformation(\StructType\BrowserInformation $browserInformation = null)
    {
        if (is_null($browserInformation) || (is_array($browserInformation) && empty($browserInformation))) {
            unset($this->browserInformation);
        } else {
            $this->browserInformation = $browserInformation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Click
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
