<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BrowserInformation StructType
 * @subpackage Structs
 */
class BrowserInformation extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $name;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $version;
    /**
     * The platform
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $platform;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $country;
    /**
     * The httpAcceptCharset
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $httpAcceptCharset;
    /**
     * The httpAcceptLanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $httpAcceptLanguage;
    /**
     * The httpAcceptEncoding
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $httpAcceptEncoding;
    /**
     * The httpAccept
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $httpAccept;
    /**
     * The httpUserAgent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $httpUserAgent;
    /**
     * Constructor method for BrowserInformation
     * @uses BrowserInformation::setName()
     * @uses BrowserInformation::setVersion()
     * @uses BrowserInformation::setPlatform()
     * @uses BrowserInformation::setCountry()
     * @uses BrowserInformation::setHttpAcceptCharset()
     * @uses BrowserInformation::setHttpAcceptLanguage()
     * @uses BrowserInformation::setHttpAcceptEncoding()
     * @uses BrowserInformation::setHttpAccept()
     * @uses BrowserInformation::setHttpUserAgent()
     * @param \StructType\_string $name
     * @param \StructType\_string $version
     * @param \StructType\_string $platform
     * @param \StructType\_string $country
     * @param \StructType\_string $httpAcceptCharset
     * @param \StructType\_string $httpAcceptLanguage
     * @param \StructType\_string $httpAcceptEncoding
     * @param \StructType\_string $httpAccept
     * @param \StructType\_string $httpUserAgent
     */
    public function __construct(\StructType\_string $name = null, \StructType\_string $version = null, \StructType\_string $platform = null, \StructType\_string $country = null, \StructType\_string $httpAcceptCharset = null, \StructType\_string $httpAcceptLanguage = null, \StructType\_string $httpAcceptEncoding = null, \StructType\_string $httpAccept = null, \StructType\_string $httpUserAgent = null)
    {
        $this
            ->setName($name)
            ->setVersion($version)
            ->setPlatform($platform)
            ->setCountry($country)
            ->setHttpAcceptCharset($httpAcceptCharset)
            ->setHttpAcceptLanguage($httpAcceptLanguage)
            ->setHttpAcceptEncoding($httpAcceptEncoding)
            ->setHttpAccept($httpAccept)
            ->setHttpUserAgent($httpUserAgent);
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $name
     * @return \StructType\BrowserInformation
     */
    public function setName(\StructType\_string $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get version value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getVersion()
    {
        return isset($this->version) ? $this->version : null;
    }
    /**
     * Set version value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $version
     * @return \StructType\BrowserInformation
     */
    public function setVersion(\StructType\_string $version = null)
    {
        if (is_null($version) || (is_array($version) && empty($version))) {
            unset($this->version);
        } else {
            $this->version = $version;
        }
        return $this;
    }
    /**
     * Get platform value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getPlatform()
    {
        return isset($this->platform) ? $this->platform : null;
    }
    /**
     * Set platform value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $platform
     * @return \StructType\BrowserInformation
     */
    public function setPlatform(\StructType\_string $platform = null)
    {
        if (is_null($platform) || (is_array($platform) && empty($platform))) {
            unset($this->platform);
        } else {
            $this->platform = $platform;
        }
        return $this;
    }
    /**
     * Get country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getCountry()
    {
        return isset($this->country) ? $this->country : null;
    }
    /**
     * Set country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $country
     * @return \StructType\BrowserInformation
     */
    public function setCountry(\StructType\_string $country = null)
    {
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->country);
        } else {
            $this->country = $country;
        }
        return $this;
    }
    /**
     * Get httpAcceptCharset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getHttpAcceptCharset()
    {
        return isset($this->httpAcceptCharset) ? $this->httpAcceptCharset : null;
    }
    /**
     * Set httpAcceptCharset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $httpAcceptCharset
     * @return \StructType\BrowserInformation
     */
    public function setHttpAcceptCharset(\StructType\_string $httpAcceptCharset = null)
    {
        if (is_null($httpAcceptCharset) || (is_array($httpAcceptCharset) && empty($httpAcceptCharset))) {
            unset($this->httpAcceptCharset);
        } else {
            $this->httpAcceptCharset = $httpAcceptCharset;
        }
        return $this;
    }
    /**
     * Get httpAcceptLanguage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getHttpAcceptLanguage()
    {
        return isset($this->httpAcceptLanguage) ? $this->httpAcceptLanguage : null;
    }
    /**
     * Set httpAcceptLanguage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $httpAcceptLanguage
     * @return \StructType\BrowserInformation
     */
    public function setHttpAcceptLanguage(\StructType\_string $httpAcceptLanguage = null)
    {
        if (is_null($httpAcceptLanguage) || (is_array($httpAcceptLanguage) && empty($httpAcceptLanguage))) {
            unset($this->httpAcceptLanguage);
        } else {
            $this->httpAcceptLanguage = $httpAcceptLanguage;
        }
        return $this;
    }
    /**
     * Get httpAcceptEncoding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getHttpAcceptEncoding()
    {
        return isset($this->httpAcceptEncoding) ? $this->httpAcceptEncoding : null;
    }
    /**
     * Set httpAcceptEncoding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $httpAcceptEncoding
     * @return \StructType\BrowserInformation
     */
    public function setHttpAcceptEncoding(\StructType\_string $httpAcceptEncoding = null)
    {
        if (is_null($httpAcceptEncoding) || (is_array($httpAcceptEncoding) && empty($httpAcceptEncoding))) {
            unset($this->httpAcceptEncoding);
        } else {
            $this->httpAcceptEncoding = $httpAcceptEncoding;
        }
        return $this;
    }
    /**
     * Get httpAccept value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getHttpAccept()
    {
        return isset($this->httpAccept) ? $this->httpAccept : null;
    }
    /**
     * Set httpAccept value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $httpAccept
     * @return \StructType\BrowserInformation
     */
    public function setHttpAccept(\StructType\_string $httpAccept = null)
    {
        if (is_null($httpAccept) || (is_array($httpAccept) && empty($httpAccept))) {
            unset($this->httpAccept);
        } else {
            $this->httpAccept = $httpAccept;
        }
        return $this;
    }
    /**
     * Get httpUserAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getHttpUserAgent()
    {
        return isset($this->httpUserAgent) ? $this->httpUserAgent : null;
    }
    /**
     * Set httpUserAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $httpUserAgent
     * @return \StructType\BrowserInformation
     */
    public function setHttpUserAgent(\StructType\_string $httpUserAgent = null)
    {
        if (is_null($httpUserAgent) || (is_array($httpUserAgent) && empty($httpUserAgent))) {
            unset($this->httpUserAgent);
        } else {
            $this->httpUserAgent = $httpUserAgent;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BrowserInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
