<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Account StructType
 * @subpackage Structs
 */
class Account extends AbstractStructBase
{
    /**
     * The network
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $network;
    /**
     * The accountId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $accountId;
    /**
     * Constructor method for Account
     * @uses Account::setNetwork()
     * @uses Account::setAccountId()
     * @param \StructType\_string $network
     * @param \StructType\_string $accountId
     */
    public function __construct(\StructType\_string $network = null, \StructType\_string $accountId = null)
    {
        $this
            ->setNetwork($network)
            ->setAccountId($accountId);
    }
    /**
     * Get network value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getNetwork()
    {
        return isset($this->network) ? $this->network : null;
    }
    /**
     * Set network value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $network
     * @return \StructType\Account
     */
    public function setNetwork(\StructType\_string $network = null)
    {
        if (is_null($network) || (is_array($network) && empty($network))) {
            unset($this->network);
        } else {
            $this->network = $network;
        }
        return $this;
    }
    /**
     * Get accountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getAccountId()
    {
        return isset($this->accountId) ? $this->accountId : null;
    }
    /**
     * Set accountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $accountId
     * @return \StructType\Account
     */
    public function setAccountId(\StructType\_string $accountId = null)
    {
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->accountId);
        } else {
            $this->accountId = $accountId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Account
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
