<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Smsupdate ServiceType
 * @subpackage Services
 */
class Smsupdate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sms_update
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Sms_update $parameters
     * @return \StructType\Sms_updateResponse|bool
     */
    public function sms_update(\StructType\Sms_update $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sms_update($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Sms_updateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
