<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Smsget ServiceType
 * @subpackage Services
 */
class Smsget extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sms_getAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Sms_getAll $parameters
     * @return \StructType\Sms_getAllResponse|bool
     */
    public function sms_getAll(\StructType\Sms_getAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sms_getAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sms_getById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Sms_getById $parameters
     * @return \StructType\Sms_getByIdResponse|bool
     */
    public function sms_getById(\StructType\Sms_getById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sms_getById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sms_getByObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Sms_getByObject $parameters
     * @return \StructType\Sms_getByObjectResponse|bool
     */
    public function sms_getByObject(\StructType\Sms_getByObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sms_getByObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Sms_getAllResponse|\StructType\Sms_getByIdResponse|\StructType\Sms_getByObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
