<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Smscreate ServiceType
 * @subpackage Services
 */
class Smscreate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sms_create
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Sms_create $parameters
     * @return \StructType\Sms_createResponse|bool
     */
    public function sms_create(\StructType\Sms_create $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sms_create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Sms_createResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
