<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Resourcefree ServiceType
 * @subpackage Services
 */
class Resourcefree extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named resource_free
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Resource_free $parameters
     * @return \StructType\Resource_freeResponse|bool
     */
    public function resource_free(\StructType\Resource_free $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->resource_free($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Resource_freeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
