<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Open ServiceType
 * @subpackage Services
 */
class Open extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named openSet_getOpen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OpenSet_getOpen $parameters
     * @return \StructType\OpenSet_getOpenResponse|bool
     */
    public function openSet_getOpen(\StructType\OpenSet_getOpen $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->openSet_getOpen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named openSet_getOpens
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OpenSet_getOpens $parameters
     * @return \StructType\OpenSet_getOpensResponse|bool
     */
    public function openSet_getOpens(\StructType\OpenSet_getOpens $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->openSet_getOpens($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named openSet_getOpenIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OpenSet_getOpenIds $parameters
     * @return \StructType\OpenSet_getOpenIdsResponse|bool
     */
    public function openSet_getOpenIds(\StructType\OpenSet_getOpenIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->openSet_getOpenIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OpenSet_getOpenIdsResponse|\StructType\OpenSet_getOpenResponse|\StructType\OpenSet_getOpensResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
