<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Magentotest ServiceType
 * @subpackage Services
 */
class Magentotest extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named magento_testConnection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Magento_testConnection $parameters
     * @return \StructType\Magento_testConnectionResponse|bool
     */
    public function magento_testConnection(\StructType\Magento_testConnection $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magento_testConnection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Magento_testConnectionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
