<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Groupinsert ServiceType
 * @subpackage Services
 */
class Groupinsert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named group_insert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Group_insert $parameters
     * @return \StructType\Group_insertResponse|bool
     */
    public function group_insert(\StructType\Group_insert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->group_insert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Group_insertResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
