<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Groupadd ServiceType
 * @subpackage Services
 */
class Groupadd extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named group_addMembersInBulk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Group_addMembersInBulk $parameters
     * @return \StructType\Group_addMembersInBulkResponse|bool
     */
    public function group_addMembersInBulk(\StructType\Group_addMembersInBulk $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->group_addMembersInBulk($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named group_addMember
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Group_addMember $parameters
     * @return \StructType\Group_addMemberResponse|bool
     */
    public function group_addMember(\StructType\Group_addMember $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->group_addMember($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Group_addMemberResponse|\StructType\Group_addMembersInBulkResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
