<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Emaillist ServiceType
 * @subpackage Services
 */
class Emaillist extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named email_listOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Email_listOptions $parameters
     * @return \StructType\Email_listOptionsResponse|bool
     */
    public function email_listOptions(\StructType\Email_listOptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->email_listOptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Email_listOptionsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
