<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delivery ServiceType
 * @subpackage Services
 */
class Delivery extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deliverySet_getDelivery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeliverySet_getDelivery $parameters
     * @return \StructType\DeliverySet_getDeliveryResponse|bool
     */
    public function deliverySet_getDelivery(\StructType\DeliverySet_getDelivery $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deliverySet_getDelivery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deliverySet_getDeliveries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeliverySet_getDeliveries $parameters
     * @return \StructType\DeliverySet_getDeliveriesResponse|bool
     */
    public function deliverySet_getDeliveries(\StructType\DeliverySet_getDeliveries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deliverySet_getDeliveries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeliverySet_getDeliveriesResponse|\StructType\DeliverySet_getDeliveryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
