<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customerupdate ServiceType
 * @subpackage Services
 */
class Customerupdate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named customer_update
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_update $parameters
     * @return \StructType\Customer_updateResponse|bool
     */
    public function customer_update(\StructType\Customer_update $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_update($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Customer_updateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
