<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customerinsert ServiceType
 * @subpackage Services
 */
class Customerinsert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named customer_insertBulkUnique
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_insertBulkUnique $parameters
     * @return \StructType\Customer_insertBulkUniqueResponse|bool
     */
    public function customer_insertBulkUnique(\StructType\Customer_insertBulkUnique $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_insertBulkUnique($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customer_insert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_insert $parameters
     * @return \StructType\Customer_insertResponse|bool
     */
    public function customer_insert(\StructType\Customer_insert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_insert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customer_insertUnique
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_insertUnique $parameters
     * @return \StructType\Customer_insertUniqueResponse|bool
     */
    public function customer_insertUnique(\StructType\Customer_insertUnique $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_insertUnique($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Customer_insertBulkUniqueResponse|\StructType\Customer_insertResponse|\StructType\Customer_insertUniqueResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
