<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customerdelete ServiceType
 * @subpackage Services
 */
class Customerdelete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named customer_delete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_delete $parameters
     * @return \StructType\Customer_deleteResponse|bool
     */
    public function customer_delete(\StructType\Customer_delete $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_delete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Customer_deleteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
