<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customer ServiceType
 * @subpackage Services
 */
class Customer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named customerSet_getCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerSet_getCustomer $parameters
     * @return \StructType\CustomerSet_getCustomerResponse|bool
     */
    public function customerSet_getCustomer(\StructType\CustomerSet_getCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customerSet_getCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customerSet_getCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerSet_getCustomers $parameters
     * @return \StructType\CustomerSet_getCustomersResponse|bool
     */
    public function customerSet_getCustomers(\StructType\CustomerSet_getCustomers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customerSet_getCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customerSet_getCustomerIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerSet_getCustomerIds $parameters
     * @return \StructType\CustomerSet_getCustomerIdsResponse|bool
     */
    public function customerSet_getCustomerIds(\StructType\CustomerSet_getCustomerIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customerSet_getCustomerIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CustomerSet_getCustomerIdsResponse|\StructType\CustomerSet_getCustomerResponse|\StructType\CustomerSet_getCustomersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
