<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Conversion ServiceType
 * @subpackage Services
 */
class Conversion extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named conversionTracking_track
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConversionTracking_track $parameters
     * @return \StructType\ConversionTracking_trackResponse|bool
     */
    public function conversionTracking_track(\StructType\ConversionTracking_track $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->conversionTracking_track($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConversionTracking_trackResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
