<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Campaignhas ServiceType
 * @subpackage Services
 */
class Campaignhas extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named campaign_hasMember
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Campaign_hasMember $parameters
     * @return \StructType\Campaign_hasMemberResponse|bool
     */
    public function campaign_hasMember(\StructType\Campaign_hasMember $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->campaign_hasMember($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Campaign_hasMemberResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
