<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bounce ServiceType
 * @subpackage Services
 */
class Bounce extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named bounceSet_getBounce
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BounceSet_getBounce $parameters
     * @return \StructType\BounceSet_getBounceResponse|bool
     */
    public function bounceSet_getBounce(\StructType\BounceSet_getBounce $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->bounceSet_getBounce($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named bounceSet_getBounces
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BounceSet_getBounces $parameters
     * @return \StructType\BounceSet_getBouncesResponse|bool
     */
    public function bounceSet_getBounces(\StructType\BounceSet_getBounces $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->bounceSet_getBounces($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named bounceSet_getBounceIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BounceSet_getBounceIds $parameters
     * @return \StructType\BounceSet_getBounceIdsResponse|bool
     */
    public function bounceSet_getBounceIds(\StructType\BounceSet_getBounceIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->bounceSet_getBounceIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BounceSet_getBounceIdsResponse|\StructType\BounceSet_getBounceResponse|\StructType\BounceSet_getBouncesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
