<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOpen ArrayType
 * @subpackage Arrays
 */
class ArrayOfOpen extends AbstractStructArrayBase
{
    /**
     * The Open
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Open[]
     */
    public $Open;
    /**
     * Constructor method for ArrayOfOpen
     * @uses ArrayOfOpen::setOpen()
     * @param \StructType\Open[] $open
     */
    public function __construct(array $open = array())
    {
        $this
            ->setOpen($open);
    }
    /**
     * Get Open value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Open[]|null
     */
    public function getOpen()
    {
        return isset($this->Open) ? $this->Open : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOpen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOpen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOpenForArrayConstraintsFromSetOpen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOpenOpenItem) {
            // validation for constraint: itemType
            if (!$arrayOfOpenOpenItem instanceof \StructType\Open) {
                $invalidValues[] = is_object($arrayOfOpenOpenItem) ? get_class($arrayOfOpenOpenItem) : sprintf('%s(%s)', gettype($arrayOfOpenOpenItem), var_export($arrayOfOpenOpenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Open property can only contain items of type \StructType\Open, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Open value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Open[] $open
     * @return \ArrayType\ArrayOfOpen
     */
    public function setOpen(array $open = array())
    {
        // validation for constraint: array
        if ('' !== ($openArrayErrorMessage = self::validateOpenForArrayConstraintsFromSetOpen($open))) {
            throw new \InvalidArgumentException($openArrayErrorMessage, __LINE__);
        }
        if (is_null($open) || (is_array($open) && empty($open))) {
            unset($this->Open);
        } else {
            $this->Open = $open;
        }
        return $this;
    }
    /**
     * Add item to Open value
     * @throws \InvalidArgumentException
     * @param \StructType\Open $item
     * @return \ArrayType\ArrayOfOpen
     */
    public function addToOpen(\StructType\Open $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Open) {
            throw new \InvalidArgumentException(sprintf('The Open property can only contain items of type \StructType\Open, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Open[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Open|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Open|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Open|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Open|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Open|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Open
     */
    public function getAttributeName()
    {
        return 'Open';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOpen
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
