<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMailingLink ArrayType
 * @subpackage Arrays
 */
class ArrayOfMailingLink extends AbstractStructArrayBase
{
    /**
     * The MailingLink
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MailingLink[]
     */
    public $MailingLink;
    /**
     * Constructor method for ArrayOfMailingLink
     * @uses ArrayOfMailingLink::setMailingLink()
     * @param \StructType\MailingLink[] $mailingLink
     */
    public function __construct(array $mailingLink = array())
    {
        $this
            ->setMailingLink($mailingLink);
    }
    /**
     * Get MailingLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MailingLink[]|null
     */
    public function getMailingLink()
    {
        return isset($this->MailingLink) ? $this->MailingLink : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMailingLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMailingLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMailingLinkForArrayConstraintsFromSetMailingLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMailingLinkMailingLinkItem) {
            // validation for constraint: itemType
            if (!$arrayOfMailingLinkMailingLinkItem instanceof \StructType\MailingLink) {
                $invalidValues[] = is_object($arrayOfMailingLinkMailingLinkItem) ? get_class($arrayOfMailingLinkMailingLinkItem) : sprintf('%s(%s)', gettype($arrayOfMailingLinkMailingLinkItem), var_export($arrayOfMailingLinkMailingLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MailingLink property can only contain items of type \StructType\MailingLink, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MailingLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MailingLink[] $mailingLink
     * @return \ArrayType\ArrayOfMailingLink
     */
    public function setMailingLink(array $mailingLink = array())
    {
        // validation for constraint: array
        if ('' !== ($mailingLinkArrayErrorMessage = self::validateMailingLinkForArrayConstraintsFromSetMailingLink($mailingLink))) {
            throw new \InvalidArgumentException($mailingLinkArrayErrorMessage, __LINE__);
        }
        if (is_null($mailingLink) || (is_array($mailingLink) && empty($mailingLink))) {
            unset($this->MailingLink);
        } else {
            $this->MailingLink = $mailingLink;
        }
        return $this;
    }
    /**
     * Add item to MailingLink value
     * @throws \InvalidArgumentException
     * @param \StructType\MailingLink $item
     * @return \ArrayType\ArrayOfMailingLink
     */
    public function addToMailingLink(\StructType\MailingLink $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MailingLink) {
            throw new \InvalidArgumentException(sprintf('The MailingLink property can only contain items of type \StructType\MailingLink, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MailingLink[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MailingLink|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MailingLink|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MailingLink|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MailingLink|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MailingLink|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MailingLink
     */
    public function getAttributeName()
    {
        return 'MailingLink';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMailingLink
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
