<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMailing ArrayType
 * @subpackage Arrays
 */
class ArrayOfMailing extends AbstractStructArrayBase
{
    /**
     * The Mailing
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Mailing[]
     */
    public $Mailing;
    /**
     * Constructor method for ArrayOfMailing
     * @uses ArrayOfMailing::setMailing()
     * @param \StructType\Mailing[] $mailing
     */
    public function __construct(array $mailing = array())
    {
        $this
            ->setMailing($mailing);
    }
    /**
     * Get Mailing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Mailing[]|null
     */
    public function getMailing()
    {
        return isset($this->Mailing) ? $this->Mailing : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMailing method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMailing method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMailingForArrayConstraintsFromSetMailing(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMailingMailingItem) {
            // validation for constraint: itemType
            if (!$arrayOfMailingMailingItem instanceof \StructType\Mailing) {
                $invalidValues[] = is_object($arrayOfMailingMailingItem) ? get_class($arrayOfMailingMailingItem) : sprintf('%s(%s)', gettype($arrayOfMailingMailingItem), var_export($arrayOfMailingMailingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mailing property can only contain items of type \StructType\Mailing, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mailing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Mailing[] $mailing
     * @return \ArrayType\ArrayOfMailing
     */
    public function setMailing(array $mailing = array())
    {
        // validation for constraint: array
        if ('' !== ($mailingArrayErrorMessage = self::validateMailingForArrayConstraintsFromSetMailing($mailing))) {
            throw new \InvalidArgumentException($mailingArrayErrorMessage, __LINE__);
        }
        if (is_null($mailing) || (is_array($mailing) && empty($mailing))) {
            unset($this->Mailing);
        } else {
            $this->Mailing = $mailing;
        }
        return $this;
    }
    /**
     * Add item to Mailing value
     * @throws \InvalidArgumentException
     * @param \StructType\Mailing $item
     * @return \ArrayType\ArrayOfMailing
     */
    public function addToMailing(\StructType\Mailing $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Mailing) {
            throw new \InvalidArgumentException(sprintf('The Mailing property can only contain items of type \StructType\Mailing, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mailing[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Mailing|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Mailing|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Mailing|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Mailing|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Mailing|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Mailing
     */
    public function getAttributeName()
    {
        return 'Mailing';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMailing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
