<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEmailBlock ArrayType
 * @subpackage Arrays
 */
class ArrayOfEmailBlock extends AbstractStructArrayBase
{
    /**
     * The EmailBlock
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EmailBlock[]
     */
    public $EmailBlock;
    /**
     * Constructor method for ArrayOfEmailBlock
     * @uses ArrayOfEmailBlock::setEmailBlock()
     * @param \StructType\EmailBlock[] $emailBlock
     */
    public function __construct(array $emailBlock = array())
    {
        $this
            ->setEmailBlock($emailBlock);
    }
    /**
     * Get EmailBlock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EmailBlock[]|null
     */
    public function getEmailBlock()
    {
        return isset($this->EmailBlock) ? $this->EmailBlock : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEmailBlock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmailBlock method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailBlockForArrayConstraintsFromSetEmailBlock(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEmailBlockEmailBlockItem) {
            // validation for constraint: itemType
            if (!$arrayOfEmailBlockEmailBlockItem instanceof \StructType\EmailBlock) {
                $invalidValues[] = is_object($arrayOfEmailBlockEmailBlockItem) ? get_class($arrayOfEmailBlockEmailBlockItem) : sprintf('%s(%s)', gettype($arrayOfEmailBlockEmailBlockItem), var_export($arrayOfEmailBlockEmailBlockItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmailBlock property can only contain items of type \StructType\EmailBlock, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmailBlock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EmailBlock[] $emailBlock
     * @return \ArrayType\ArrayOfEmailBlock
     */
    public function setEmailBlock(array $emailBlock = array())
    {
        // validation for constraint: array
        if ('' !== ($emailBlockArrayErrorMessage = self::validateEmailBlockForArrayConstraintsFromSetEmailBlock($emailBlock))) {
            throw new \InvalidArgumentException($emailBlockArrayErrorMessage, __LINE__);
        }
        if (is_null($emailBlock) || (is_array($emailBlock) && empty($emailBlock))) {
            unset($this->EmailBlock);
        } else {
            $this->EmailBlock = $emailBlock;
        }
        return $this;
    }
    /**
     * Add item to EmailBlock value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailBlock $item
     * @return \ArrayType\ArrayOfEmailBlock
     */
    public function addToEmailBlock(\StructType\EmailBlock $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmailBlock) {
            throw new \InvalidArgumentException(sprintf('The EmailBlock property can only contain items of type \StructType\EmailBlock, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EmailBlock[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EmailBlock|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EmailBlock|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EmailBlock|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EmailBlock|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EmailBlock|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EmailBlock
     */
    public function getAttributeName()
    {
        return 'EmailBlock';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEmailBlock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
