<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDelivery ArrayType
 * @subpackage Arrays
 */
class ArrayOfDelivery extends AbstractStructArrayBase
{
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Delivery[]
     */
    public $Delivery;
    /**
     * Constructor method for ArrayOfDelivery
     * @uses ArrayOfDelivery::setDelivery()
     * @param \StructType\Delivery[] $delivery
     */
    public function __construct(array $delivery = array())
    {
        $this
            ->setDelivery($delivery);
    }
    /**
     * Get Delivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Delivery[]|null
     */
    public function getDelivery()
    {
        return isset($this->Delivery) ? $this->Delivery : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDelivery method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDelivery method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryForArrayConstraintsFromSetDelivery(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDeliveryDeliveryItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeliveryDeliveryItem instanceof \StructType\Delivery) {
                $invalidValues[] = is_object($arrayOfDeliveryDeliveryItem) ? get_class($arrayOfDeliveryDeliveryItem) : sprintf('%s(%s)', gettype($arrayOfDeliveryDeliveryItem), var_export($arrayOfDeliveryDeliveryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Delivery property can only contain items of type \StructType\Delivery, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Delivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Delivery[] $delivery
     * @return \ArrayType\ArrayOfDelivery
     */
    public function setDelivery(array $delivery = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryArrayErrorMessage = self::validateDeliveryForArrayConstraintsFromSetDelivery($delivery))) {
            throw new \InvalidArgumentException($deliveryArrayErrorMessage, __LINE__);
        }
        if (is_null($delivery) || (is_array($delivery) && empty($delivery))) {
            unset($this->Delivery);
        } else {
            $this->Delivery = $delivery;
        }
        return $this;
    }
    /**
     * Add item to Delivery value
     * @throws \InvalidArgumentException
     * @param \StructType\Delivery $item
     * @return \ArrayType\ArrayOfDelivery
     */
    public function addToDelivery(\StructType\Delivery $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Delivery) {
            throw new \InvalidArgumentException(sprintf('The Delivery property can only contain items of type \StructType\Delivery, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Delivery[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Delivery|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Delivery|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Delivery|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Delivery|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Delivery|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Delivery
     */
    public function getAttributeName()
    {
        return 'Delivery';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDelivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
