<?php

namespace hkpost\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserData StructType
 * @subpackage Structs
 */
class UserData extends AbstractStructBase
{
    /**
     * The deviceName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $deviceName;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $model;
    /**
     * The osVersion
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $osVersion;
    /**
     * The udid
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $udid;
    /**
     * The version
     * @var float
     */
    public $version;
    /**
     * Constructor method for UserData
     * @uses UserData::setDeviceName()
     * @uses UserData::setModel()
     * @uses UserData::setOsVersion()
     * @uses UserData::setUdid()
     * @uses UserData::setVersion()
     * @param string $deviceName
     * @param string $model
     * @param string $osVersion
     * @param string $udid
     * @param float $version
     */
    public function __construct($deviceName = null, $model = null, $osVersion = null, $udid = null, $version = null)
    {
        $this
            ->setDeviceName($deviceName)
            ->setModel($model)
            ->setOsVersion($osVersion)
            ->setUdid($udid)
            ->setVersion($version);
    }
    /**
     * Get deviceName value
     * @return string|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param string $deviceName
     * @return \hkpost\StructType\UserData
     */
    public function setDeviceName($deviceName = null)
    {
        // validation for constraint: string
        if (!is_null($deviceName) && !is_string($deviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceName)), __LINE__);
        }
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param string $model
     * @return \hkpost\StructType\UserData
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($model)), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get osVersion value
     * @return string|null
     */
    public function getOsVersion()
    {
        return $this->osVersion;
    }
    /**
     * Set osVersion value
     * @param string $osVersion
     * @return \hkpost\StructType\UserData
     */
    public function setOsVersion($osVersion = null)
    {
        // validation for constraint: string
        if (!is_null($osVersion) && !is_string($osVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($osVersion)), __LINE__);
        }
        $this->osVersion = $osVersion;
        return $this;
    }
    /**
     * Get udid value
     * @return string|null
     */
    public function getUdid()
    {
        return $this->udid;
    }
    /**
     * Set udid value
     * @param string $udid
     * @return \hkpost\StructType\UserData
     */
    public function setUdid($udid = null)
    {
        // validation for constraint: string
        if (!is_null($udid) && !is_string($udid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($udid)), __LINE__);
        }
        $this->udid = $udid;
        return $this;
    }
    /**
     * Get version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param float $version
     * @return \hkpost\StructType\UserData
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \hkpost\StructType\UserData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
