<?php

namespace hkpost\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mail ServiceType
 * @subpackage Services
 */
class Mail extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named mailTrackingDetailwSE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hkpost\StructType\MailTrackingDetailwSE $parameters
     * @return \hkpost\StructType\MailTrackingDetailwSEResponse|bool
     */
    public function mailTrackingDetailwSE(\hkpost\StructType\MailTrackingDetailwSE $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->mailTrackingDetailwSE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hkpost\StructType\MailTrackingDetailwSEResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
