<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ShipType StructType
 * @subpackage Structs
 */
class DocTypeRef_ShipType extends AbstractStructBase
{
    /**
     * The Shipper
     * @var \StructType\DocTypeRef_ContactInfoType
     */
    public $Shipper;
    /**
     * The Pickup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocTypeRef_ContactInfoType
     */
    public $Pickup;
    /**
     * The BookingRequestor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocTypeRef_ContactInfoType
     */
    public $BookingRequestor;
    /**
     * The Buyer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocTypeRef_ContactInfoType1
     */
    public $Buyer;
    /**
     * The Recipient
     * @var \StructType\DocTypeRef_ContactInfoType
     */
    public $Recipient;
    /**
     * Constructor method for docTypeRef_ShipType
     * @uses DocTypeRef_ShipType::setShipper()
     * @uses DocTypeRef_ShipType::setPickup()
     * @uses DocTypeRef_ShipType::setBookingRequestor()
     * @uses DocTypeRef_ShipType::setBuyer()
     * @uses DocTypeRef_ShipType::setRecipient()
     * @param \StructType\DocTypeRef_ContactInfoType $shipper
     * @param \StructType\DocTypeRef_ContactInfoType $pickup
     * @param \StructType\DocTypeRef_ContactInfoType $bookingRequestor
     * @param \StructType\DocTypeRef_ContactInfoType1 $buyer
     * @param \StructType\DocTypeRef_ContactInfoType $recipient
     */
    public function __construct(\StructType\DocTypeRef_ContactInfoType $shipper = null, \StructType\DocTypeRef_ContactInfoType $pickup = null, \StructType\DocTypeRef_ContactInfoType $bookingRequestor = null, \StructType\DocTypeRef_ContactInfoType1 $buyer = null, \StructType\DocTypeRef_ContactInfoType $recipient = null)
    {
        $this
            ->setShipper($shipper)
            ->setPickup($pickup)
            ->setBookingRequestor($bookingRequestor)
            ->setBuyer($buyer)
            ->setRecipient($recipient);
    }
    /**
     * Get Shipper value
     * @return \StructType\DocTypeRef_ContactInfoType|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \StructType\DocTypeRef_ContactInfoType $shipper
     * @return \StructType\DocTypeRef_ShipType
     */
    public function setShipper(\StructType\DocTypeRef_ContactInfoType $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get Pickup value
     * @return \StructType\DocTypeRef_ContactInfoType|null
     */
    public function getPickup()
    {
        return $this->Pickup;
    }
    /**
     * Set Pickup value
     * @param \StructType\DocTypeRef_ContactInfoType $pickup
     * @return \StructType\DocTypeRef_ShipType
     */
    public function setPickup(\StructType\DocTypeRef_ContactInfoType $pickup = null)
    {
        $this->Pickup = $pickup;
        return $this;
    }
    /**
     * Get BookingRequestor value
     * @return \StructType\DocTypeRef_ContactInfoType|null
     */
    public function getBookingRequestor()
    {
        return $this->BookingRequestor;
    }
    /**
     * Set BookingRequestor value
     * @param \StructType\DocTypeRef_ContactInfoType $bookingRequestor
     * @return \StructType\DocTypeRef_ShipType
     */
    public function setBookingRequestor(\StructType\DocTypeRef_ContactInfoType $bookingRequestor = null)
    {
        $this->BookingRequestor = $bookingRequestor;
        return $this;
    }
    /**
     * Get Buyer value
     * @return \StructType\DocTypeRef_ContactInfoType1|null
     */
    public function getBuyer()
    {
        return $this->Buyer;
    }
    /**
     * Set Buyer value
     * @param \StructType\DocTypeRef_ContactInfoType1 $buyer
     * @return \StructType\DocTypeRef_ShipType
     */
    public function setBuyer(\StructType\DocTypeRef_ContactInfoType1 $buyer = null)
    {
        $this->Buyer = $buyer;
        return $this;
    }
    /**
     * Get Recipient value
     * @return \StructType\DocTypeRef_ContactInfoType|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @param \StructType\DocTypeRef_ContactInfoType $recipient
     * @return \StructType\DocTypeRef_ShipType
     */
    public function setRecipient(\StructType\DocTypeRef_ContactInfoType $recipient = null)
    {
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocTypeRef_ShipType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
