<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_RequestedShipmentType StructType
 * @subpackage Structs
 */
class DocTypeRef_RequestedShipmentType extends AbstractStructBase
{
    /**
     * The ShipmentInfo
     * @var \StructType\DocTypeRef_ShipmentInfoType
     */
    public $ShipmentInfo;
    /**
     * The ShipTimestamp
     * Meta information extracted from the WSDL
     * - documentation: Identifies the date and time the package is tendered. Both the date and time portions of the string are expected to be used. The date should not be a past date or a date more than 10 days in the future. The time is the local time of
     * the shipment based on the shipper's time zone. The date component must be in the format: YYYY-MM-DD; the time component must be in the format: HH:MM:SS using a 24 hour clock. The date and time parts are separated by the letter T (e.g.
     * 2010-02-05T14:00:00 GMT+01:00).
     * - base: xsd:token
     * - maxLength: 29
     * - whiteSpace: collapse
     * @var string
     */
    public $ShipTimestamp;
    /**
     * The PickupLocationCloseTime
     * Meta information extracted from the WSDL
     * - documentation: Identifies the customer cut-off time for courier pick-up. Only the time portions is expected to be used. The time is the local time on the shipper's country where the package is available to be picked-up, and the component must be in
     * the format: HH:MM using a 24 hour clock (e.g. 14:00).
     * - base: xsd:token
     * - maxLength: 5
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PickupLocationCloseTime;
    /**
     * The SpecialPickupInstruction
     * Meta information extracted from the WSDL
     * - documentation: Details special pickup instructions you may wish to send to the DHL Courier .
     * - base: xsd:string
     * - maxLength: 75
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $SpecialPickupInstruction;
    /**
     * The PickupLocation
     * Meta information extracted from the WSDL
     * - documentation: Provides information on where the package should be picked up by DHL courier.
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PickupLocation;
    /**
     * The PaymentInfo
     * Meta information extracted from the WSDL
     * - documentation: Details the potential terms of trade for this specific shipment
     * @var string
     */
    public $PaymentInfo;
    /**
     * The InternationalDetail
     * Meta information extracted from the WSDL
     * - documentation: Conveys data elements for international shipping
     * @var \StructType\DocTypeRef_InternationDetailType
     */
    public $InternationalDetail;
    /**
     * The OnDemandDeliveryOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocTypeRef_OnDemandDeliveryOptions
     */
    public $OnDemandDeliveryOptions;
    /**
     * The OnDemandDeliveryURLRequest
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $OnDemandDeliveryURLRequest;
    /**
     * The Ship
     * @var \StructType\DocTypeRef_ShipType
     */
    public $Ship;
    /**
     * The Packages
     * @var \StructType\DocTypeRef_PackagesType
     */
    public $Packages;
    /**
     * The DangerousGoods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocTypeRef_DangerousGoods
     */
    public $DangerousGoods;
    /**
     * The GetRateEstimates
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $GetRateEstimates;
    /**
     * The ShipmentNotifications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocTypeRef_ShipmentNotifications
     */
    public $ShipmentNotifications;
    /**
     * Constructor method for docTypeRef_RequestedShipmentType
     * @uses DocTypeRef_RequestedShipmentType::setShipmentInfo()
     * @uses DocTypeRef_RequestedShipmentType::setShipTimestamp()
     * @uses DocTypeRef_RequestedShipmentType::setPickupLocationCloseTime()
     * @uses DocTypeRef_RequestedShipmentType::setSpecialPickupInstruction()
     * @uses DocTypeRef_RequestedShipmentType::setPickupLocation()
     * @uses DocTypeRef_RequestedShipmentType::setPaymentInfo()
     * @uses DocTypeRef_RequestedShipmentType::setInternationalDetail()
     * @uses DocTypeRef_RequestedShipmentType::setOnDemandDeliveryOptions()
     * @uses DocTypeRef_RequestedShipmentType::setOnDemandDeliveryURLRequest()
     * @uses DocTypeRef_RequestedShipmentType::setShip()
     * @uses DocTypeRef_RequestedShipmentType::setPackages()
     * @uses DocTypeRef_RequestedShipmentType::setDangerousGoods()
     * @uses DocTypeRef_RequestedShipmentType::setGetRateEstimates()
     * @uses DocTypeRef_RequestedShipmentType::setShipmentNotifications()
     * @param \StructType\DocTypeRef_ShipmentInfoType $shipmentInfo
     * @param string $shipTimestamp
     * @param string $pickupLocationCloseTime
     * @param string $specialPickupInstruction
     * @param string $pickupLocation
     * @param string $paymentInfo
     * @param \StructType\DocTypeRef_InternationDetailType $internationalDetail
     * @param \StructType\DocTypeRef_OnDemandDeliveryOptions $onDemandDeliveryOptions
     * @param string $onDemandDeliveryURLRequest
     * @param \StructType\DocTypeRef_ShipType $ship
     * @param \StructType\DocTypeRef_PackagesType $packages
     * @param \StructType\DocTypeRef_DangerousGoods $dangerousGoods
     * @param string $getRateEstimates
     * @param \StructType\DocTypeRef_ShipmentNotifications $shipmentNotifications
     */
    public function __construct(\StructType\DocTypeRef_ShipmentInfoType $shipmentInfo = null, $shipTimestamp = null, $pickupLocationCloseTime = null, $specialPickupInstruction = null, $pickupLocation = null, $paymentInfo = null, \StructType\DocTypeRef_InternationDetailType $internationalDetail = null, \StructType\DocTypeRef_OnDemandDeliveryOptions $onDemandDeliveryOptions = null, $onDemandDeliveryURLRequest = 'N', \StructType\DocTypeRef_ShipType $ship = null, \StructType\DocTypeRef_PackagesType $packages = null, \StructType\DocTypeRef_DangerousGoods $dangerousGoods = null, $getRateEstimates = 'N', \StructType\DocTypeRef_ShipmentNotifications $shipmentNotifications = null)
    {
        $this
            ->setShipmentInfo($shipmentInfo)
            ->setShipTimestamp($shipTimestamp)
            ->setPickupLocationCloseTime($pickupLocationCloseTime)
            ->setSpecialPickupInstruction($specialPickupInstruction)
            ->setPickupLocation($pickupLocation)
            ->setPaymentInfo($paymentInfo)
            ->setInternationalDetail($internationalDetail)
            ->setOnDemandDeliveryOptions($onDemandDeliveryOptions)
            ->setOnDemandDeliveryURLRequest($onDemandDeliveryURLRequest)
            ->setShip($ship)
            ->setPackages($packages)
            ->setDangerousGoods($dangerousGoods)
            ->setGetRateEstimates($getRateEstimates)
            ->setShipmentNotifications($shipmentNotifications);
    }
    /**
     * Get ShipmentInfo value
     * @return \StructType\DocTypeRef_ShipmentInfoType|null
     */
    public function getShipmentInfo()
    {
        return $this->ShipmentInfo;
    }
    /**
     * Set ShipmentInfo value
     * @param \StructType\DocTypeRef_ShipmentInfoType $shipmentInfo
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setShipmentInfo(\StructType\DocTypeRef_ShipmentInfoType $shipmentInfo = null)
    {
        $this->ShipmentInfo = $shipmentInfo;
        return $this;
    }
    /**
     * Get ShipTimestamp value
     * @return string|null
     */
    public function getShipTimestamp()
    {
        return $this->ShipTimestamp;
    }
    /**
     * Set ShipTimestamp value
     * @param string $shipTimestamp
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setShipTimestamp($shipTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($shipTimestamp) && !is_string($shipTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipTimestamp, true), gettype($shipTimestamp)), __LINE__);
        }
        // validation for constraint: maxLength(29)
        if (!is_null($shipTimestamp) && mb_strlen($shipTimestamp) > 29) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 29', mb_strlen($shipTimestamp)), __LINE__);
        }
        $this->ShipTimestamp = $shipTimestamp;
        return $this;
    }
    /**
     * Get PickupLocationCloseTime value
     * @return string|null
     */
    public function getPickupLocationCloseTime()
    {
        return $this->PickupLocationCloseTime;
    }
    /**
     * Set PickupLocationCloseTime value
     * @param string $pickupLocationCloseTime
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setPickupLocationCloseTime($pickupLocationCloseTime = null)
    {
        // validation for constraint: string
        if (!is_null($pickupLocationCloseTime) && !is_string($pickupLocationCloseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupLocationCloseTime, true), gettype($pickupLocationCloseTime)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($pickupLocationCloseTime) && mb_strlen($pickupLocationCloseTime) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($pickupLocationCloseTime)), __LINE__);
        }
        $this->PickupLocationCloseTime = $pickupLocationCloseTime;
        return $this;
    }
    /**
     * Get SpecialPickupInstruction value
     * @return string|null
     */
    public function getSpecialPickupInstruction()
    {
        return $this->SpecialPickupInstruction;
    }
    /**
     * Set SpecialPickupInstruction value
     * @param string $specialPickupInstruction
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setSpecialPickupInstruction($specialPickupInstruction = null)
    {
        // validation for constraint: string
        if (!is_null($specialPickupInstruction) && !is_string($specialPickupInstruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialPickupInstruction, true), gettype($specialPickupInstruction)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($specialPickupInstruction) && mb_strlen($specialPickupInstruction) > 75) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen($specialPickupInstruction)), __LINE__);
        }
        $this->SpecialPickupInstruction = $specialPickupInstruction;
        return $this;
    }
    /**
     * Get PickupLocation value
     * @return string|null
     */
    public function getPickupLocation()
    {
        return $this->PickupLocation;
    }
    /**
     * Set PickupLocation value
     * @param string $pickupLocation
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setPickupLocation($pickupLocation = null)
    {
        // validation for constraint: string
        if (!is_null($pickupLocation) && !is_string($pickupLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupLocation, true), gettype($pickupLocation)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($pickupLocation) && mb_strlen($pickupLocation) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($pickupLocation)), __LINE__);
        }
        $this->PickupLocation = $pickupLocation;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return string|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @uses \EnumType\PaymentInfo::valueIsValid()
     * @uses \EnumType\PaymentInfo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentInfo
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setPaymentInfo($paymentInfo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentInfo::valueIsValid($paymentInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentInfo', is_array($paymentInfo) ? implode(', ', $paymentInfo) : var_export($paymentInfo, true), implode(', ', \EnumType\PaymentInfo::getValidValues())), __LINE__);
        }
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Get InternationalDetail value
     * @return \StructType\DocTypeRef_InternationDetailType|null
     */
    public function getInternationalDetail()
    {
        return $this->InternationalDetail;
    }
    /**
     * Set InternationalDetail value
     * @param \StructType\DocTypeRef_InternationDetailType $internationalDetail
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setInternationalDetail(\StructType\DocTypeRef_InternationDetailType $internationalDetail = null)
    {
        $this->InternationalDetail = $internationalDetail;
        return $this;
    }
    /**
     * Get OnDemandDeliveryOptions value
     * @return \StructType\DocTypeRef_OnDemandDeliveryOptions|null
     */
    public function getOnDemandDeliveryOptions()
    {
        return $this->OnDemandDeliveryOptions;
    }
    /**
     * Set OnDemandDeliveryOptions value
     * @param \StructType\DocTypeRef_OnDemandDeliveryOptions $onDemandDeliveryOptions
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setOnDemandDeliveryOptions(\StructType\DocTypeRef_OnDemandDeliveryOptions $onDemandDeliveryOptions = null)
    {
        $this->OnDemandDeliveryOptions = $onDemandDeliveryOptions;
        return $this;
    }
    /**
     * Get OnDemandDeliveryURLRequest value
     * @return string|null
     */
    public function getOnDemandDeliveryURLRequest()
    {
        return $this->OnDemandDeliveryURLRequest;
    }
    /**
     * Set OnDemandDeliveryURLRequest value
     * @uses \EnumType\OnDemandDeliveryURLRequest::valueIsValid()
     * @uses \EnumType\OnDemandDeliveryURLRequest::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $onDemandDeliveryURLRequest
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setOnDemandDeliveryURLRequest($onDemandDeliveryURLRequest = 'N')
    {
        // validation for constraint: enumeration
        if (!\EnumType\OnDemandDeliveryURLRequest::valueIsValid($onDemandDeliveryURLRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OnDemandDeliveryURLRequest', is_array($onDemandDeliveryURLRequest) ? implode(', ', $onDemandDeliveryURLRequest) : var_export($onDemandDeliveryURLRequest, true), implode(', ', \EnumType\OnDemandDeliveryURLRequest::getValidValues())), __LINE__);
        }
        $this->OnDemandDeliveryURLRequest = $onDemandDeliveryURLRequest;
        return $this;
    }
    /**
     * Get Ship value
     * @return \StructType\DocTypeRef_ShipType|null
     */
    public function getShip()
    {
        return $this->Ship;
    }
    /**
     * Set Ship value
     * @param \StructType\DocTypeRef_ShipType $ship
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setShip(\StructType\DocTypeRef_ShipType $ship = null)
    {
        $this->Ship = $ship;
        return $this;
    }
    /**
     * Get Packages value
     * @return \StructType\DocTypeRef_PackagesType|null
     */
    public function getPackages()
    {
        return $this->Packages;
    }
    /**
     * Set Packages value
     * @param \StructType\DocTypeRef_PackagesType $packages
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setPackages(\StructType\DocTypeRef_PackagesType $packages = null)
    {
        $this->Packages = $packages;
        return $this;
    }
    /**
     * Get DangerousGoods value
     * @return \StructType\DocTypeRef_DangerousGoods|null
     */
    public function getDangerousGoods()
    {
        return $this->DangerousGoods;
    }
    /**
     * Set DangerousGoods value
     * @param \StructType\DocTypeRef_DangerousGoods $dangerousGoods
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setDangerousGoods(\StructType\DocTypeRef_DangerousGoods $dangerousGoods = null)
    {
        $this->DangerousGoods = $dangerousGoods;
        return $this;
    }
    /**
     * Get GetRateEstimates value
     * @return string|null
     */
    public function getGetRateEstimates()
    {
        return $this->GetRateEstimates;
    }
    /**
     * Set GetRateEstimates value
     * @uses \EnumType\GetRateEstimates::valueIsValid()
     * @uses \EnumType\GetRateEstimates::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $getRateEstimates
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setGetRateEstimates($getRateEstimates = 'N')
    {
        // validation for constraint: enumeration
        if (!\EnumType\GetRateEstimates::valueIsValid($getRateEstimates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GetRateEstimates', is_array($getRateEstimates) ? implode(', ', $getRateEstimates) : var_export($getRateEstimates, true), implode(', ', \EnumType\GetRateEstimates::getValidValues())), __LINE__);
        }
        $this->GetRateEstimates = $getRateEstimates;
        return $this;
    }
    /**
     * Get ShipmentNotifications value
     * @return \StructType\DocTypeRef_ShipmentNotifications|null
     */
    public function getShipmentNotifications()
    {
        return $this->ShipmentNotifications;
    }
    /**
     * Set ShipmentNotifications value
     * @param \StructType\DocTypeRef_ShipmentNotifications $shipmentNotifications
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public function setShipmentNotifications(\StructType\DocTypeRef_ShipmentNotifications $shipmentNotifications = null)
    {
        $this->ShipmentNotifications = $shipmentNotifications;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocTypeRef_RequestedShipmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
