<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_Documents StructType
 * @subpackage Structs
 */
class DocTypeRef_Documents extends AbstractStructBase
{
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: 999
     * - minOccurs: 0
     * @var \StructType\DocTypeRef_Document[]
     */
    public $Document;
    /**
     * Constructor method for docTypeRef_Documents
     * @uses DocTypeRef_Documents::setDocument()
     * @param \StructType\DocTypeRef_Document[] $document
     */
    public function __construct(array $document = array())
    {
        $this
            ->setDocument($document);
    }
    /**
     * Get Document value
     * @return \StructType\DocTypeRef_Document[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_DocumentsDocumentItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_DocumentsDocumentItem instanceof \StructType\DocTypeRef_Document) {
                $invalidValues[] = is_object($docTypeRef_DocumentsDocumentItem) ? get_class($docTypeRef_DocumentsDocumentItem) : sprintf('%s(%s)', gettype($docTypeRef_DocumentsDocumentItem), var_export($docTypeRef_DocumentsDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type \StructType\DocTypeRef_Document, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \StructType\DocTypeRef_Document[] $document
     * @return \StructType\DocTypeRef_Documents
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($document) && count($document) > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999', count($document)), __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \StructType\DocTypeRef_Document $item
     * @return \StructType\DocTypeRef_Documents
     */
    public function addToDocument(\StructType\DocTypeRef_Document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocTypeRef_Document) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type \StructType\DocTypeRef_Document, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($this->Document) && count($this->Document) >= 999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999', count($this->Document)), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocTypeRef_Documents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
