<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Breakdown StructType
 * @subpackage Structs
 */
class Breakdown extends AbstractStructBase
{
    /**
     * The ChargeType
     * Meta information extracted from the WSDL
     * - documentation: If a breakdown is provided, details can either be "TAX" or "DISCOUNT"
     * - minOccurs: 0
     * @var string
     */
    public $ChargeType;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Discount or tax type codes as provided by DHL Express. Example values; For discount; P – promotional S – special
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The actual amount of the discount/tax
     * - minOccurs: 0
     * @var string
     */
    public $Amount;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - documentation: Percentage of the discount/tax
     * - minOccurs: 0
     * @var string
     */
    public $Rate;
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - documentation: The base amount of the service charge
     * - minOccurs: 0
     * @var string
     */
    public $BaseAmount;
    /**
     * Constructor method for Breakdown
     * @uses Breakdown::setChargeType()
     * @uses Breakdown::setType()
     * @uses Breakdown::setAmount()
     * @uses Breakdown::setRate()
     * @uses Breakdown::setBaseAmount()
     * @param string $chargeType
     * @param string $type
     * @param string $amount
     * @param string $rate
     * @param string $baseAmount
     */
    public function __construct($chargeType = null, $type = null, $amount = null, $rate = null, $baseAmount = null)
    {
        $this
            ->setChargeType($chargeType)
            ->setType($type)
            ->setAmount($amount)
            ->setRate($rate)
            ->setBaseAmount($baseAmount);
    }
    /**
     * Get ChargeType value
     * @return string|null
     */
    public function getChargeType()
    {
        return $this->ChargeType;
    }
    /**
     * Set ChargeType value
     * @param string $chargeType
     * @return \StructType\Breakdown
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: string
        if (!is_null($chargeType) && !is_string($chargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeType, true), gettype($chargeType)), __LINE__);
        }
        $this->ChargeType = $chargeType;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\Breakdown
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \StructType\Breakdown
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param string $rate
     * @return \StructType\Breakdown
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get BaseAmount value
     * @return string|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param string $baseAmount
     * @return \StructType\Breakdown
     */
    public function setBaseAmount($baseAmount = null)
    {
        // validation for constraint: string
        if (!is_null($baseAmount) && !is_string($baseAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseAmount, true), gettype($baseAmount)), __LINE__);
        }
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Breakdown
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
