<?php

namespace EnumType;

/**
 * This class stands for UnitOfMeasurement2 EnumType
 * @subpackage Enumerations
 */
class UnitOfMeasurement2
{
    /**
     * Constant for value 'SI'
     * @return string 'SI'
     */
    const VALUE_SI = 'SI';
    /**
     * Constant for value 'SU'
     * @return string 'SU'
     */
    const VALUE_SU = 'SU';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SI
     * @uses self::VALUE_SU
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SI,
            self::VALUE_SU,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
