<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ServiceType StructType
 * @subpackage Structs
 */
class DocTypeRef_ServiceType extends AbstractStructBase
{
    /**
     * The TotalNet
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * @var \StructType\TotalNet[]
     */
    public $TotalNet;
    /**
     * The Charges
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\Charges[]
     */
    public $Charges;
    /**
     * The TotalChargeTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\DocTypeRef_TotalChargeTypes[]
     */
    public $TotalChargeTypes;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocTypeRef_ItemsType
     */
    public $Items;
    /**
     * The DeliveryTime
     * Meta information extracted from the WSDL
     * - documentation: Identifies the date and time the package is tendered. Both the date and time portions of the string are expected to be used. The date should not be a past date or a date more than 10 days in the future. The time is the local time of
     * the shipment based on the shipper's time zone. The date component must be in the format: YYYY-MM-DD; the time component must be in the format: HH:MM:SS using a 24 hour clock. The date and time parts are separated by the letter T (e.g.
     * 2006-06-26T17:00:00).
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryTime;
    /**
     * The DeliveryType
     * Meta information extracted from the WSDL
     * - documentation: Delivery Date capabilities considering customs clearance days. QDDF - is the fastest ("docs") transit time as quoted to the customer at booking or shipment creation. No custom clearance is considered. QDDC - constitutes DHL's service
     * commitment as quoted at booking/shipment creation. QDDc builds in clearance time, and potentially other special operational non-transport component(s), when relevant.
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryType;
    /**
     * The CutoffTime
     * Meta information extracted from the WSDL
     * - documentation: Identifies the cutoff date and time the package needs to be tendered to the shipper, in order to meet the estimated delivery time.The time is the local time of the shipment based on the shipper's time zone. The date component must be
     * in the format:YYYY-MM-DD; the time component must be in the format: HH:MM:SS using a 24 hour clock. The date and time parts are separated by the letter T (e.g. 2006-06-26T17:00:00).
     * - minOccurs: 0
     * @var string
     */
    public $CutoffTime;
    /**
     * The CutoffTimeGMT
     * Meta information extracted from the WSDL
     * - documentation: Pickup cut off time in GMT
     * - minOccurs: 0
     * @var string
     */
    public $CutoffTimeGMT;
    /**
     * The CutoffTimeOffset
     * Meta information extracted from the WSDL
     * - documentation: Pickup cut off time GMT Offset
     * - minOccurs: 0
     * @var string
     */
    public $CutoffTimeOffset;
    /**
     * The NextBusinessDayInd
     * Meta information extracted from the WSDL
     * - documentation: This indicator demonstrates whether the pickup date is the next business day (Y) or the requested business day (N). If the requested ship date is beyond the cutoff for that business day (or it is requested on weekend), the indicator
     * will be set to Y. If it is on the same business day as requested, the value is set to N.
     * - minOccurs: 0
     * @var string
     */
    public $NextBusinessDayInd;
    /**
     * The PickupWindowEarliestTime
     * Meta information extracted from the WSDL
     * - documentation: The DHL earliest time possible for pickup
     * - minOccurs: 0
     * @var string
     */
    public $PickupWindowEarliestTime;
    /**
     * The PickupWindowLatestTime
     * Meta information extracted from the WSDL
     * - documentation: The DHL latest time possible for pickup
     * - minOccurs: 0
     * @var string
     */
    public $PickupWindowLatestTime;
    /**
     * The OriginServiceArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocTypeRef_ServiceAreaType
     */
    public $OriginServiceArea;
    /**
     * The DestinationServiceArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocTypeRef_ServiceAreaType
     */
    public $DestinationServiceArea;
    /**
     * The ServiceName
     * Meta information extracted from the WSDL
     * - documentation: Local service name
     * - minOccurs: 0
     * @var string
     */
    public $ServiceName;
    /**
     * The LocalServiceType
     * Meta information extracted from the WSDL
     * - documentation: DHL “local / country specific” Product Code used to ship the items. Optional and applicable only to get Landed Cost
     * - minOccurs: 0
     * @var string
     */
    public $LocalServiceType;
    /**
     * The LocalServiceCountryCode
     * Meta information extracted from the WSDL
     * - documentation: The country code for the local service used
     * - base: xsd:token
     * - maxLength: 2
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $LocalServiceCountryCode;
    /**
     * The NetworkTypeCode
     * Meta information extracted from the WSDL
     * - documentation: The NetworkTypeCode element indicates the product belongs to the Day Definite (DD) or Time Definite (TD) network. Possible Values; - ‘DD’, Day Definite product - ‘TD’, Time Definite product
     * - minOccurs: 0
     * @var string
     */
    public $NetworkTypeCode;
    /**
     * The CustomerAgreementInd
     * Meta information extracted from the WSDL
     * - documentation: Indicator that the product only can be offered to customers with prior agreement.
     * - minOccurs: 0
     * @var string
     */
    public $CustomerAgreementInd;
    /**
     * The TotalTransitDays
     * Meta information extracted from the WSDL
     * - documentation: The number of transit days
     * - minOccurs: 0
     * @var string
     */
    public $TotalTransitDays;
    /**
     * The PickupAdditionalDays
     * Meta information extracted from the WSDL
     * - documentation: This is additional transit delays (in days) for shipment picked up from the mentioned city or postal area to arrival at the service area
     * - minOccurs: 0
     * @var string
     */
    public $PickupAdditionalDays;
    /**
     * The DeliveryAdditionalDays
     * Meta information extracted from the WSDL
     * - documentation: This is additional transit delays (in days) for shipment delivered to the mentioned city or postal area following arrival at the service area
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryAdditionalDays;
    /**
     * The VolumetricWeight
     * Meta information extracted from the WSDL
     * - documentation: The dimensional weight of the shipment
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $VolumetricWeight;
    /**
     * The QuotedWeight
     * Meta information extracted from the WSDL
     * - documentation: The quoted weight of the shipment
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $QuotedWeight;
    /**
     * The UnitOfMeasurement
     * Meta information extracted from the WSDL
     * - documentation: The unit of measurement for the dimensions of the package. Possible values: - SI, international metric system (KG, CM) - SU, the US system of measurement (LB, IN)
     * - minOccurs: 0
     * @var string
     */
    public $UnitOfMeasurement;
    /**
     * The PickupDayOfWeek
     * Meta information extracted from the WSDL
     * - documentation: Pickup day of the week number
     * - minOccurs: 0
     * @var string
     */
    public $PickupDayOfWeek;
    /**
     * The DestinationDayOfWeek
     * Meta information extracted from the WSDL
     * - documentation: Destination day of the week number
     * - minOccurs: 0
     * @var string
     */
    public $DestinationDayOfWeek;
    /**
     * The PricingDate
     * Meta information extracted from the WSDL
     * - documentation: The date when the rates for DHL products and services is provided
     * - minOccurs: 0
     * @var string
     */
    public $PricingDate;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: The service type provided from the courier.
     * - base: xsd:token
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $type;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - documentation: The rate type of the charges for this package. Possible returned rate types are: PAYOR_ACCOUNT, RATED_ACCOUNT.
     * @var string
     */
    public $account;
    /**
     * Constructor method for docTypeRef_ServiceType
     * @uses DocTypeRef_ServiceType::setTotalNet()
     * @uses DocTypeRef_ServiceType::setCharges()
     * @uses DocTypeRef_ServiceType::setTotalChargeTypes()
     * @uses DocTypeRef_ServiceType::setItems()
     * @uses DocTypeRef_ServiceType::setDeliveryTime()
     * @uses DocTypeRef_ServiceType::setDeliveryType()
     * @uses DocTypeRef_ServiceType::setCutoffTime()
     * @uses DocTypeRef_ServiceType::setCutoffTimeGMT()
     * @uses DocTypeRef_ServiceType::setCutoffTimeOffset()
     * @uses DocTypeRef_ServiceType::setNextBusinessDayInd()
     * @uses DocTypeRef_ServiceType::setPickupWindowEarliestTime()
     * @uses DocTypeRef_ServiceType::setPickupWindowLatestTime()
     * @uses DocTypeRef_ServiceType::setOriginServiceArea()
     * @uses DocTypeRef_ServiceType::setDestinationServiceArea()
     * @uses DocTypeRef_ServiceType::setServiceName()
     * @uses DocTypeRef_ServiceType::setLocalServiceType()
     * @uses DocTypeRef_ServiceType::setLocalServiceCountryCode()
     * @uses DocTypeRef_ServiceType::setNetworkTypeCode()
     * @uses DocTypeRef_ServiceType::setCustomerAgreementInd()
     * @uses DocTypeRef_ServiceType::setTotalTransitDays()
     * @uses DocTypeRef_ServiceType::setPickupAdditionalDays()
     * @uses DocTypeRef_ServiceType::setDeliveryAdditionalDays()
     * @uses DocTypeRef_ServiceType::setVolumetricWeight()
     * @uses DocTypeRef_ServiceType::setQuotedWeight()
     * @uses DocTypeRef_ServiceType::setUnitOfMeasurement()
     * @uses DocTypeRef_ServiceType::setPickupDayOfWeek()
     * @uses DocTypeRef_ServiceType::setDestinationDayOfWeek()
     * @uses DocTypeRef_ServiceType::setPricingDate()
     * @uses DocTypeRef_ServiceType::setType()
     * @uses DocTypeRef_ServiceType::setAccount()
     * @param \StructType\TotalNet[] $totalNet
     * @param \StructType\Charges[] $charges
     * @param \StructType\DocTypeRef_TotalChargeTypes[] $totalChargeTypes
     * @param \StructType\DocTypeRef_ItemsType $items
     * @param string $deliveryTime
     * @param string $deliveryType
     * @param string $cutoffTime
     * @param string $cutoffTimeGMT
     * @param string $cutoffTimeOffset
     * @param string $nextBusinessDayInd
     * @param string $pickupWindowEarliestTime
     * @param string $pickupWindowLatestTime
     * @param \StructType\DocTypeRef_ServiceAreaType $originServiceArea
     * @param \StructType\DocTypeRef_ServiceAreaType $destinationServiceArea
     * @param string $serviceName
     * @param string $localServiceType
     * @param string $localServiceCountryCode
     * @param string $networkTypeCode
     * @param string $customerAgreementInd
     * @param string $totalTransitDays
     * @param string $pickupAdditionalDays
     * @param string $deliveryAdditionalDays
     * @param float $volumetricWeight
     * @param float $quotedWeight
     * @param string $unitOfMeasurement
     * @param string $pickupDayOfWeek
     * @param string $destinationDayOfWeek
     * @param string $pricingDate
     * @param string $type
     * @param string $account
     */
    public function __construct(array $totalNet = array(), array $charges = array(), array $totalChargeTypes = array(), \StructType\DocTypeRef_ItemsType $items = null, $deliveryTime = null, $deliveryType = null, $cutoffTime = null, $cutoffTimeGMT = null, $cutoffTimeOffset = null, $nextBusinessDayInd = null, $pickupWindowEarliestTime = null, $pickupWindowLatestTime = null, \StructType\DocTypeRef_ServiceAreaType $originServiceArea = null, \StructType\DocTypeRef_ServiceAreaType $destinationServiceArea = null, $serviceName = null, $localServiceType = null, $localServiceCountryCode = null, $networkTypeCode = null, $customerAgreementInd = null, $totalTransitDays = null, $pickupAdditionalDays = null, $deliveryAdditionalDays = null, $volumetricWeight = null, $quotedWeight = null, $unitOfMeasurement = null, $pickupDayOfWeek = null, $destinationDayOfWeek = null, $pricingDate = null, $type = null, $account = null)
    {
        $this
            ->setTotalNet($totalNet)
            ->setCharges($charges)
            ->setTotalChargeTypes($totalChargeTypes)
            ->setItems($items)
            ->setDeliveryTime($deliveryTime)
            ->setDeliveryType($deliveryType)
            ->setCutoffTime($cutoffTime)
            ->setCutoffTimeGMT($cutoffTimeGMT)
            ->setCutoffTimeOffset($cutoffTimeOffset)
            ->setNextBusinessDayInd($nextBusinessDayInd)
            ->setPickupWindowEarliestTime($pickupWindowEarliestTime)
            ->setPickupWindowLatestTime($pickupWindowLatestTime)
            ->setOriginServiceArea($originServiceArea)
            ->setDestinationServiceArea($destinationServiceArea)
            ->setServiceName($serviceName)
            ->setLocalServiceType($localServiceType)
            ->setLocalServiceCountryCode($localServiceCountryCode)
            ->setNetworkTypeCode($networkTypeCode)
            ->setCustomerAgreementInd($customerAgreementInd)
            ->setTotalTransitDays($totalTransitDays)
            ->setPickupAdditionalDays($pickupAdditionalDays)
            ->setDeliveryAdditionalDays($deliveryAdditionalDays)
            ->setVolumetricWeight($volumetricWeight)
            ->setQuotedWeight($quotedWeight)
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setPickupDayOfWeek($pickupDayOfWeek)
            ->setDestinationDayOfWeek($destinationDayOfWeek)
            ->setPricingDate($pricingDate)
            ->setType($type)
            ->setAccount($account);
    }
    /**
     * Get TotalNet value
     * @return \StructType\TotalNet[]|null
     */
    public function getTotalNet()
    {
        return $this->TotalNet;
    }
    /**
     * This method is responsible for validating the values passed to the setTotalNet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalNet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTotalNetForArrayConstraintsFromSetTotalNet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_ServiceTypeTotalNetItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_ServiceTypeTotalNetItem instanceof \StructType\TotalNet) {
                $invalidValues[] = is_object($docTypeRef_ServiceTypeTotalNetItem) ? get_class($docTypeRef_ServiceTypeTotalNetItem) : sprintf('%s(%s)', gettype($docTypeRef_ServiceTypeTotalNetItem), var_export($docTypeRef_ServiceTypeTotalNetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TotalNet property can only contain items of type \StructType\TotalNet, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TotalNet value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalNet[] $totalNet
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setTotalNet(array $totalNet = array())
    {
        // validation for constraint: array
        if ('' !== ($totalNetArrayErrorMessage = self::validateTotalNetForArrayConstraintsFromSetTotalNet($totalNet))) {
            throw new \InvalidArgumentException($totalNetArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($totalNet) && count($totalNet) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($totalNet)), __LINE__);
        }
        $this->TotalNet = $totalNet;
        return $this;
    }
    /**
     * Add item to TotalNet value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalNet $item
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function addToTotalNet(\StructType\TotalNet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TotalNet) {
            throw new \InvalidArgumentException(sprintf('The TotalNet property can only contain items of type \StructType\TotalNet, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->TotalNet) && count($this->TotalNet) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->TotalNet)), __LINE__);
        }
        $this->TotalNet[] = $item;
        return $this;
    }
    /**
     * Get Charges value
     * @return \StructType\Charges[]|null
     */
    public function getCharges()
    {
        return $this->Charges;
    }
    /**
     * This method is responsible for validating the values passed to the setCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargesForArrayConstraintsFromSetCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_ServiceTypeChargesItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_ServiceTypeChargesItem instanceof \StructType\Charges) {
                $invalidValues[] = is_object($docTypeRef_ServiceTypeChargesItem) ? get_class($docTypeRef_ServiceTypeChargesItem) : sprintf('%s(%s)', gettype($docTypeRef_ServiceTypeChargesItem), var_export($docTypeRef_ServiceTypeChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Charges property can only contain items of type \StructType\Charges, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Charges value
     * @throws \InvalidArgumentException
     * @param \StructType\Charges[] $charges
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setCharges(array $charges = array())
    {
        // validation for constraint: array
        if ('' !== ($chargesArrayErrorMessage = self::validateChargesForArrayConstraintsFromSetCharges($charges))) {
            throw new \InvalidArgumentException($chargesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($charges) && count($charges) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($charges)), __LINE__);
        }
        $this->Charges = $charges;
        return $this;
    }
    /**
     * Add item to Charges value
     * @throws \InvalidArgumentException
     * @param \StructType\Charges $item
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function addToCharges(\StructType\Charges $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Charges) {
            throw new \InvalidArgumentException(sprintf('The Charges property can only contain items of type \StructType\Charges, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->Charges) && count($this->Charges) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->Charges)), __LINE__);
        }
        $this->Charges[] = $item;
        return $this;
    }
    /**
     * Get TotalChargeTypes value
     * @return \StructType\DocTypeRef_TotalChargeTypes[]|null
     */
    public function getTotalChargeTypes()
    {
        return $this->TotalChargeTypes;
    }
    /**
     * This method is responsible for validating the values passed to the setTotalChargeTypes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalChargeTypes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTotalChargeTypesForArrayConstraintsFromSetTotalChargeTypes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_ServiceTypeTotalChargeTypesItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_ServiceTypeTotalChargeTypesItem instanceof \StructType\DocTypeRef_TotalChargeTypes) {
                $invalidValues[] = is_object($docTypeRef_ServiceTypeTotalChargeTypesItem) ? get_class($docTypeRef_ServiceTypeTotalChargeTypesItem) : sprintf('%s(%s)', gettype($docTypeRef_ServiceTypeTotalChargeTypesItem), var_export($docTypeRef_ServiceTypeTotalChargeTypesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TotalChargeTypes property can only contain items of type \StructType\DocTypeRef_TotalChargeTypes, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TotalChargeTypes value
     * @throws \InvalidArgumentException
     * @param \StructType\DocTypeRef_TotalChargeTypes[] $totalChargeTypes
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setTotalChargeTypes(array $totalChargeTypes = array())
    {
        // validation for constraint: array
        if ('' !== ($totalChargeTypesArrayErrorMessage = self::validateTotalChargeTypesForArrayConstraintsFromSetTotalChargeTypes($totalChargeTypes))) {
            throw new \InvalidArgumentException($totalChargeTypesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($totalChargeTypes) && count($totalChargeTypes) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($totalChargeTypes)), __LINE__);
        }
        $this->TotalChargeTypes = $totalChargeTypes;
        return $this;
    }
    /**
     * Add item to TotalChargeTypes value
     * @throws \InvalidArgumentException
     * @param \StructType\DocTypeRef_TotalChargeTypes $item
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function addToTotalChargeTypes(\StructType\DocTypeRef_TotalChargeTypes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocTypeRef_TotalChargeTypes) {
            throw new \InvalidArgumentException(sprintf('The TotalChargeTypes property can only contain items of type \StructType\DocTypeRef_TotalChargeTypes, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->TotalChargeTypes) && count($this->TotalChargeTypes) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->TotalChargeTypes)), __LINE__);
        }
        $this->TotalChargeTypes[] = $item;
        return $this;
    }
    /**
     * Get Items value
     * @return \StructType\DocTypeRef_ItemsType|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \StructType\DocTypeRef_ItemsType $items
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setItems(\StructType\DocTypeRef_ItemsType $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get DeliveryTime value
     * @return string|null
     */
    public function getDeliveryTime()
    {
        return $this->DeliveryTime;
    }
    /**
     * Set DeliveryTime value
     * @param string $deliveryTime
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setDeliveryTime($deliveryTime = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTime) && !is_string($deliveryTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTime, true), gettype($deliveryTime)), __LINE__);
        }
        $this->DeliveryTime = $deliveryTime;
        return $this;
    }
    /**
     * Get DeliveryType value
     * @return string|null
     */
    public function getDeliveryType()
    {
        return $this->DeliveryType;
    }
    /**
     * Set DeliveryType value
     * @param string $deliveryType
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setDeliveryType($deliveryType = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryType) && !is_string($deliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryType, true), gettype($deliveryType)), __LINE__);
        }
        $this->DeliveryType = $deliveryType;
        return $this;
    }
    /**
     * Get CutoffTime value
     * @return string|null
     */
    public function getCutoffTime()
    {
        return $this->CutoffTime;
    }
    /**
     * Set CutoffTime value
     * @param string $cutoffTime
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setCutoffTime($cutoffTime = null)
    {
        // validation for constraint: string
        if (!is_null($cutoffTime) && !is_string($cutoffTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cutoffTime, true), gettype($cutoffTime)), __LINE__);
        }
        $this->CutoffTime = $cutoffTime;
        return $this;
    }
    /**
     * Get CutoffTimeGMT value
     * @return string|null
     */
    public function getCutoffTimeGMT()
    {
        return $this->CutoffTimeGMT;
    }
    /**
     * Set CutoffTimeGMT value
     * @param string $cutoffTimeGMT
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setCutoffTimeGMT($cutoffTimeGMT = null)
    {
        // validation for constraint: string
        if (!is_null($cutoffTimeGMT) && !is_string($cutoffTimeGMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cutoffTimeGMT, true), gettype($cutoffTimeGMT)), __LINE__);
        }
        $this->CutoffTimeGMT = $cutoffTimeGMT;
        return $this;
    }
    /**
     * Get CutoffTimeOffset value
     * @return string|null
     */
    public function getCutoffTimeOffset()
    {
        return $this->CutoffTimeOffset;
    }
    /**
     * Set CutoffTimeOffset value
     * @param string $cutoffTimeOffset
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setCutoffTimeOffset($cutoffTimeOffset = null)
    {
        // validation for constraint: string
        if (!is_null($cutoffTimeOffset) && !is_string($cutoffTimeOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cutoffTimeOffset, true), gettype($cutoffTimeOffset)), __LINE__);
        }
        $this->CutoffTimeOffset = $cutoffTimeOffset;
        return $this;
    }
    /**
     * Get NextBusinessDayInd value
     * @return string|null
     */
    public function getNextBusinessDayInd()
    {
        return $this->NextBusinessDayInd;
    }
    /**
     * Set NextBusinessDayInd value
     * @uses \EnumType\NextBusinessDayInd2::valueIsValid()
     * @uses \EnumType\NextBusinessDayInd2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nextBusinessDayInd
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setNextBusinessDayInd($nextBusinessDayInd = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NextBusinessDayInd2::valueIsValid($nextBusinessDayInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\NextBusinessDayInd2', is_array($nextBusinessDayInd) ? implode(', ', $nextBusinessDayInd) : var_export($nextBusinessDayInd, true), implode(', ', \EnumType\NextBusinessDayInd2::getValidValues())), __LINE__);
        }
        $this->NextBusinessDayInd = $nextBusinessDayInd;
        return $this;
    }
    /**
     * Get PickupWindowEarliestTime value
     * @return string|null
     */
    public function getPickupWindowEarliestTime()
    {
        return $this->PickupWindowEarliestTime;
    }
    /**
     * Set PickupWindowEarliestTime value
     * @param string $pickupWindowEarliestTime
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setPickupWindowEarliestTime($pickupWindowEarliestTime = null)
    {
        // validation for constraint: string
        if (!is_null($pickupWindowEarliestTime) && !is_string($pickupWindowEarliestTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupWindowEarliestTime, true), gettype($pickupWindowEarliestTime)), __LINE__);
        }
        $this->PickupWindowEarliestTime = $pickupWindowEarliestTime;
        return $this;
    }
    /**
     * Get PickupWindowLatestTime value
     * @return string|null
     */
    public function getPickupWindowLatestTime()
    {
        return $this->PickupWindowLatestTime;
    }
    /**
     * Set PickupWindowLatestTime value
     * @param string $pickupWindowLatestTime
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setPickupWindowLatestTime($pickupWindowLatestTime = null)
    {
        // validation for constraint: string
        if (!is_null($pickupWindowLatestTime) && !is_string($pickupWindowLatestTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupWindowLatestTime, true), gettype($pickupWindowLatestTime)), __LINE__);
        }
        $this->PickupWindowLatestTime = $pickupWindowLatestTime;
        return $this;
    }
    /**
     * Get OriginServiceArea value
     * @return \StructType\DocTypeRef_ServiceAreaType|null
     */
    public function getOriginServiceArea()
    {
        return $this->OriginServiceArea;
    }
    /**
     * Set OriginServiceArea value
     * @param \StructType\DocTypeRef_ServiceAreaType $originServiceArea
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setOriginServiceArea(\StructType\DocTypeRef_ServiceAreaType $originServiceArea = null)
    {
        $this->OriginServiceArea = $originServiceArea;
        return $this;
    }
    /**
     * Get DestinationServiceArea value
     * @return \StructType\DocTypeRef_ServiceAreaType|null
     */
    public function getDestinationServiceArea()
    {
        return $this->DestinationServiceArea;
    }
    /**
     * Set DestinationServiceArea value
     * @param \StructType\DocTypeRef_ServiceAreaType $destinationServiceArea
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setDestinationServiceArea(\StructType\DocTypeRef_ServiceAreaType $destinationServiceArea = null)
    {
        $this->DestinationServiceArea = $destinationServiceArea;
        return $this;
    }
    /**
     * Get ServiceName value
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->ServiceName;
    }
    /**
     * Set ServiceName value
     * @param string $serviceName
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        $this->ServiceName = $serviceName;
        return $this;
    }
    /**
     * Get LocalServiceType value
     * @return string|null
     */
    public function getLocalServiceType()
    {
        return $this->LocalServiceType;
    }
    /**
     * Set LocalServiceType value
     * @param string $localServiceType
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setLocalServiceType($localServiceType = null)
    {
        // validation for constraint: string
        if (!is_null($localServiceType) && !is_string($localServiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localServiceType, true), gettype($localServiceType)), __LINE__);
        }
        $this->LocalServiceType = $localServiceType;
        return $this;
    }
    /**
     * Get LocalServiceCountryCode value
     * @return string|null
     */
    public function getLocalServiceCountryCode()
    {
        return $this->LocalServiceCountryCode;
    }
    /**
     * Set LocalServiceCountryCode value
     * @param string $localServiceCountryCode
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setLocalServiceCountryCode($localServiceCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($localServiceCountryCode) && !is_string($localServiceCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localServiceCountryCode, true), gettype($localServiceCountryCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($localServiceCountryCode) && mb_strlen($localServiceCountryCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($localServiceCountryCode)), __LINE__);
        }
        $this->LocalServiceCountryCode = $localServiceCountryCode;
        return $this;
    }
    /**
     * Get NetworkTypeCode value
     * @return string|null
     */
    public function getNetworkTypeCode()
    {
        return $this->NetworkTypeCode;
    }
    /**
     * Set NetworkTypeCode value
     * @param string $networkTypeCode
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setNetworkTypeCode($networkTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($networkTypeCode) && !is_string($networkTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkTypeCode, true), gettype($networkTypeCode)), __LINE__);
        }
        $this->NetworkTypeCode = $networkTypeCode;
        return $this;
    }
    /**
     * Get CustomerAgreementInd value
     * @return string|null
     */
    public function getCustomerAgreementInd()
    {
        return $this->CustomerAgreementInd;
    }
    /**
     * Set CustomerAgreementInd value
     * @param string $customerAgreementInd
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setCustomerAgreementInd($customerAgreementInd = null)
    {
        // validation for constraint: string
        if (!is_null($customerAgreementInd) && !is_string($customerAgreementInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerAgreementInd, true), gettype($customerAgreementInd)), __LINE__);
        }
        $this->CustomerAgreementInd = $customerAgreementInd;
        return $this;
    }
    /**
     * Get TotalTransitDays value
     * @return string|null
     */
    public function getTotalTransitDays()
    {
        return $this->TotalTransitDays;
    }
    /**
     * Set TotalTransitDays value
     * @param string $totalTransitDays
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setTotalTransitDays($totalTransitDays = null)
    {
        // validation for constraint: string
        if (!is_null($totalTransitDays) && !is_string($totalTransitDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalTransitDays, true), gettype($totalTransitDays)), __LINE__);
        }
        $this->TotalTransitDays = $totalTransitDays;
        return $this;
    }
    /**
     * Get PickupAdditionalDays value
     * @return string|null
     */
    public function getPickupAdditionalDays()
    {
        return $this->PickupAdditionalDays;
    }
    /**
     * Set PickupAdditionalDays value
     * @param string $pickupAdditionalDays
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setPickupAdditionalDays($pickupAdditionalDays = null)
    {
        // validation for constraint: string
        if (!is_null($pickupAdditionalDays) && !is_string($pickupAdditionalDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupAdditionalDays, true), gettype($pickupAdditionalDays)), __LINE__);
        }
        $this->PickupAdditionalDays = $pickupAdditionalDays;
        return $this;
    }
    /**
     * Get DeliveryAdditionalDays value
     * @return string|null
     */
    public function getDeliveryAdditionalDays()
    {
        return $this->DeliveryAdditionalDays;
    }
    /**
     * Set DeliveryAdditionalDays value
     * @param string $deliveryAdditionalDays
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setDeliveryAdditionalDays($deliveryAdditionalDays = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAdditionalDays) && !is_string($deliveryAdditionalDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAdditionalDays, true), gettype($deliveryAdditionalDays)), __LINE__);
        }
        $this->DeliveryAdditionalDays = $deliveryAdditionalDays;
        return $this;
    }
    /**
     * Get VolumetricWeight value
     * @return float|null
     */
    public function getVolumetricWeight()
    {
        return $this->VolumetricWeight;
    }
    /**
     * Set VolumetricWeight value
     * @param float $volumetricWeight
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setVolumetricWeight($volumetricWeight = null)
    {
        // validation for constraint: float
        if (!is_null($volumetricWeight) && !(is_float($volumetricWeight) || is_numeric($volumetricWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volumetricWeight, true), gettype($volumetricWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($volumetricWeight) && mb_strlen(mb_substr($volumetricWeight, mb_strpos($volumetricWeight, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($volumetricWeight, true), mb_strlen(mb_substr($volumetricWeight, mb_strpos($volumetricWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($volumetricWeight) && mb_strlen(preg_replace('/(\D)/', '', $volumetricWeight)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($volumetricWeight, true), mb_strlen(preg_replace('/(\D)/', '', $volumetricWeight))), __LINE__);
        }
        $this->VolumetricWeight = $volumetricWeight;
        return $this;
    }
    /**
     * Get QuotedWeight value
     * @return float|null
     */
    public function getQuotedWeight()
    {
        return $this->QuotedWeight;
    }
    /**
     * Set QuotedWeight value
     * @param float $quotedWeight
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setQuotedWeight($quotedWeight = null)
    {
        // validation for constraint: float
        if (!is_null($quotedWeight) && !(is_float($quotedWeight) || is_numeric($quotedWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quotedWeight, true), gettype($quotedWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($quotedWeight) && mb_strlen(mb_substr($quotedWeight, mb_strpos($quotedWeight, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($quotedWeight, true), mb_strlen(mb_substr($quotedWeight, mb_strpos($quotedWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($quotedWeight) && mb_strlen(preg_replace('/(\D)/', '', $quotedWeight)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($quotedWeight, true), mb_strlen(preg_replace('/(\D)/', '', $quotedWeight))), __LINE__);
        }
        $this->QuotedWeight = $quotedWeight;
        return $this;
    }
    /**
     * Get UnitOfMeasurement value
     * @return string|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @uses \EnumType\UnitOfMeasurement2::valueIsValid()
     * @uses \EnumType\UnitOfMeasurement2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unitOfMeasurement
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setUnitOfMeasurement($unitOfMeasurement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UnitOfMeasurement2::valueIsValid($unitOfMeasurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UnitOfMeasurement2', is_array($unitOfMeasurement) ? implode(', ', $unitOfMeasurement) : var_export($unitOfMeasurement, true), implode(', ', \EnumType\UnitOfMeasurement2::getValidValues())), __LINE__);
        }
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get PickupDayOfWeek value
     * @return string|null
     */
    public function getPickupDayOfWeek()
    {
        return $this->PickupDayOfWeek;
    }
    /**
     * Set PickupDayOfWeek value
     * @param string $pickupDayOfWeek
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setPickupDayOfWeek($pickupDayOfWeek = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDayOfWeek) && !is_string($pickupDayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDayOfWeek, true), gettype($pickupDayOfWeek)), __LINE__);
        }
        $this->PickupDayOfWeek = $pickupDayOfWeek;
        return $this;
    }
    /**
     * Get DestinationDayOfWeek value
     * @return string|null
     */
    public function getDestinationDayOfWeek()
    {
        return $this->DestinationDayOfWeek;
    }
    /**
     * Set DestinationDayOfWeek value
     * @param string $destinationDayOfWeek
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setDestinationDayOfWeek($destinationDayOfWeek = null)
    {
        // validation for constraint: string
        if (!is_null($destinationDayOfWeek) && !is_string($destinationDayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationDayOfWeek, true), gettype($destinationDayOfWeek)), __LINE__);
        }
        $this->DestinationDayOfWeek = $destinationDayOfWeek;
        return $this;
    }
    /**
     * Get PricingDate value
     * @return string|null
     */
    public function getPricingDate()
    {
        return $this->PricingDate;
    }
    /**
     * Set PricingDate value
     * @param string $pricingDate
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setPricingDate($pricingDate = null)
    {
        // validation for constraint: string
        if (!is_null($pricingDate) && !is_string($pricingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingDate, true), gettype($pricingDate)), __LINE__);
        }
        $this->PricingDate = $pricingDate;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($type) && mb_strlen($type) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @uses \EnumType\_x0040_account::valueIsValid()
     * @uses \EnumType\_x0040_account::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $account
     * @return \StructType\DocTypeRef_ServiceType
     */
    public function setAccount($account = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\_x0040_account::valueIsValid($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\_x0040_account', is_array($account) ? implode(', ', $account) : var_export($account, true), implode(', ', \EnumType\_x0040_account::getValidValues())), __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocTypeRef_ServiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
